<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;

use Mnv\Models\TypeContent;
use Mnv\Models\TypeContentField;
use Mnv\Models\Users\UserGroups;
use Mnv\Models\Users\UserTypes;

/**
 * Class TypeContentAdmin
 */
class TypeContentAdmin extends AdminMnv
{

    public function fetch()
    {

        $typeContent = new TypeContent($this->request);

        $this->smarty->assign('activeItem','typecontents');
        $this->smarty->assign('title', 'Тип контента');
        /** statuses */
        $this->smarty->assign('statuses', lang('general:statuses'));

        /** получить дополнительные поля по типу контента */
        $typeContentFields = collect(TypeContentField::typeContentFields($typeContent->id, ''))->map(function ($item) {
            $item['typeName'] = TypeContentField::getNameTypeField($item['type']);
            $item['statusName'] = lang('general:statuses:' . $item['status']);

            if ($item['type'] == 'R' || $item['type'] == 'S') {
                $item['properties'] = TypeContentField::typeContentFieldProperty('propertyId ASC', $item['fieldId']);
            }

            return $item;
        })->all();
        $this->smarty->assign('typeContentFields', $typeContentFields);

        $this->smarty->assign('typeFields', TypeContentField::getTypeFields());
        $this->smarty->assign('userGroups', UserGroups::selectGroup($this->manager['userType']));

        if ($this->action == 'edit' || $this->action == 'add') {

            $typeContent->edit()->gettingInfoAboutUsers();
            if (!empty($typeContent->id)) $typeContent->getPrivileges();

        }
        else if ($this->action == 'save' || $this->action == 'apply') {

            if (empty($typeContent->data['name'])) $this->errors['name'] = true;

            if (empty($typeContent->data['fileName'])) $this->errors['fileName'] = true;
            if (preg_match('/^(type\d+|contents|content)$/i', $typeContent->data['fileName'])) $this->errors['fileNameProhibited'] = true;
            if (preg_match("/[^a-z\s]/iu", $typeContent->data['fileName'])) $this->errors['fileNameCharacters'] = true;
            $typeContent->data['fileName'] = strtolower($typeContent->data['fileName']);
            if ($fileName = $typeContent->checkFileName($typeContent->data['fileName'])) {
                if ($fileName == $typeContent->data['fileName']) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $typeContent->data['fileName'] = $fileName;
                }
            }

            if (empty($this->errors)) {
                if ($typeContent->prepare($typeContent->data, $this->manager['userId'])) {
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $typeContent->edit()->gettingInfoAboutUsers();
            if (!empty($typeContent->id)) $typeContent->getPrivileges();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->adminUrl . "/typecontents?" . $this->buildQueryString(['page' => $this->page]));
            }

        }

        $this->smarty->assign('type', $typeContent->data);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        /** Права доступа к данному шаблону */
        if ($this->manager['userType'] == UserTypes::DEVELOPER) {
            return $this->smarty->fetch('views/type-content/content.tpl');
        }


        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }
}



