{assign var=wrapper value="" scope=global}
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<title>{login:title} - {productName}</title>
	<!-- Global stylesheets -->
	<link href="/admin/assets/fonts/inter/inter.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/icons/phosphor/styles.min.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/all.min.css" id="stylesheet" rel="stylesheet" type="text/css">
	<!-- /global stylesheets -->

	<!-- Core JS files -->
{*	<script src="/admin/assets/js/configurator.js"></script>*}
{*	<script src="/admin/assets/js/bootstrap/bootstrap.bundle.min.js"></script>*}
	<!-- /core JS files -->

	<!-- Theme JS files -->
{*	<script src="/admin/assets/js/app.js"></script>*}

</head>

<body>
	<div class="page-content login-cover">
		<div class="content-wrapper">
			<div class="content d-flex justify-content-center align-items-center">
				{if isset($isRemembered) && $isRemembered eq 1}
					<!-- Unlock form -->
					<form class="login-form {*form-validate*}" method="post" action="{*{$adminUrl}/auth*}" id="login_unlock" accept-charset={$config.charset}>
						<div class="card mb-0">
							<div class="card-body">
								<div class="text-center">
									<div class="card-img-actions d-inline-block mb-3" style="height: 160px">
										<img class="rounded-circle" src="{if isset($adminManager->manager->image)}{$adminManager->manager->image->medium}{else}/admin/assets/images/demo/users/face11.jpg{/if}" width="160" height="160" alt="">
										<div class="card-img-actions-overlay card-img rounded-circle">
											<a href="" class="btn btn-outline bg-white text-white border-white border-2 btn-icon rounded-round">
												<i class="icon-question7"></i>
											</a>
										</div>
									</div>
								</div>
								{if isset($IS_BANNED_USER) && !empty($IS_BANNED_USER)}
									<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">{$IS_BANNED_USER}</div>
								{else}
									{if isset($errors)}
										{if isset($message_limit)}
											<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">{$message_limit}</div>
										{else}
											{if isset($errors)}
												{foreach from=$errors item=error key=key}
													{if !empty($error)}<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">{$error}</div>{/if}
												{/foreach}
											{/if}
										{/if}
									{/if}
									{if isset($limit_cnt)}
										<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">Осталось {$limit_cnt} {$limit_cnt|plural:'попытка':'попыток':'попытки'}</div>
									{/if}
									{if isset($isBanned)}
										<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">Вы исчерпали количество попыток на сегодня.</div>
									{else}
										<div class="text-center mb-3">
											<h6 class="font-weight-semibold mb-0">{if isset($adminManager) && !empty($adminManager)}{$adminManager->manager->fullName}{/if}</h6>
											<span class="d-block text-muted">Unlock your account</span>
										</div>

										<div class="form-group form-group-feedback form-group-feedback-right {if isset($errors.enter_password) or isset($errors.wrong_username_password) or isset($errors.enter_username_password)}error{/if}">
											<input type="password" class="form-control" id="adpass" type="password" name="login[password]" placeholder="{login:password}" autocomplete="on">
											<div class="form-control-feedback">
												<i class="icon-user-lock text-muted"></i>
											</div>
										</div>

										<button type="submit" name="action" value="login_unlock" class="btn btn-primary btn-block"><i class="icon-unlocked mr-2"></i> Unlock</button>
									{/if}
								{/if}
							</div>
						</div>
					</form>
					<!-- /unlock form -->
				{else}

					<form class="login-form {*form-validate*}" method="post" action="{*{$adminUrl}/auth*}" id="login" accept-charset={$config.charset}>
						<div class="card mb-0">
							<div class="card-body">
								<div class="text-center mb-3">
									<i class="icon-reading icon-2x text-slate-300 border-slate-300 border-3 rounded-round p-3 mb-3 mt-1"></i>
									<h5 class="mb-0">Войдите в свой аккаунт</h5>
									<span class="d-block text-muted">Ваши учетные данные</span>
								</div>
	                            {if isset($Unknown) && !empty($Unknown)}
								<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">{$Unknown}</div>
								{/if}
								{if isset($IS_BANNED_USER) && !empty($IS_BANNED_USER)}
									<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">{$IS_BANNED_USER}</div>
								{else}
									{if isset($errors)}
										{if isset($message_limit)}
											<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">{$message_limit nofilter}</div>
										{else}
											{if isset($errors)}
												{foreach from=$errors item=error key=key}
													{if !empty($error)}<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">{$error}</div>{/if}
												{/foreach}
											{/if}
										{/if}
									{/if}
									{if isset($limit_cnt)}
										<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">Осталось {$limit_cnt} попыт{$limit_cnt|plural:'ка':'ок':'ки'}</div>
									{/if}
									{if isset($isBanned)}
										<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">Вы исчерпали количество попыток на сегодня.</div>
									{else}
										<div class="mb-3">
											<label class="form-label {if isset($errors.enter_username)}error{/if}">{login:username}</label>
											<div class="form-control-feedback form-control-feedback-start">
												<input type="text" class="form-control" name="login[loginName]" value="{if isset($login.loginName)}{$login.loginName}{/if}" placeholder="john@doe.com">
												<div class="form-control-feedback-icon">
													<i class="ph-user-circle text-muted"></i>
												</div>
											</div>
										</div>

										<div class="mb-3">
											<label class="form-label {if isset($errors.enter_password) or isset($errors.wrong_username_password) or isset($errors.enter_username_password)}error{/if}">{login:password}</label>
											<div class="form-control-feedback form-control-feedback-start">
												<input type="password" class="form-control" name="login[password]" value="{if isset($login.password)}{$login.password}{/if}" placeholder="•••••••••••">
												<div class="form-control-feedback-icon">
													<i class="ph-lock text-muted"></i>
												</div>
											</div>
										</div>

										<div class="d-flex align-items-center mb-3">
											<label class="form-check">
												<input id="remember_check" type="checkbox" name="login[remember]" class="form-check-input remember_check" checked>
												<span class="form-check-label">Запомнить меня</span>
											</label>

										</div>

										<div class="mb-3">
											<button type="submit" name="action" value="login" class="btn btn-primary w-100">{login:signIn}</button>
										</div>


									{/if}
								{/if}

{*								<span class="form-text text-center text-muted">*}
{*	*}{*								Продолжая, вы подтверждаете, что ознакомились с нашими <a href="#">Условиями использования</a> и <a href="#">Политикой в отношении файлов cookie</a>.*}
{*									By continuing, you're confirming that you've read our*}
{*									<a href="#">Terms &amp; Conditions</a> and*}
{*									<a href="#">Cookie Policy</a>*}
{*								</span>*}
							</div>
						</div>
					</form>
				{/if}
			</div>
		</div>
	</div>

	<!-- Demo config -->
{*	<div class="offcanvas offcanvas-end" tabindex="-1" id="demo_config">*}
{*		<div class="position-absolute top-50 end-100 visible">*}
{*			<button type="button" class="btn btn-primary btn-icon translate-middle-y rounded-end-0" data-bs-toggle="offcanvas" data-bs-target="#demo_config">*}
{*				<i class="ph-gear"></i>*}
{*			</button>*}
{*		</div>*}

{*		<div class="offcanvas-header border-bottom py-0">*}
{*			<h5 class="offcanvas-title py-3">Demo configuration</h5>*}
{*			<button type="button" class="btn btn-light btn-sm btn-icon border-transparent rounded-pill" data-bs-dismiss="offcanvas">*}
{*				<i class="ph-x"></i>*}
{*			</button>*}
{*		</div>*}

{*		<div class="offcanvas-body">*}
{*			<div class="fw-semibold mb-2">Color mode</div>*}
{*			<div class="list-group mb-3">*}
{*				<label class="list-group-item list-group-item-action form-check border-width-1 rounded mb-2">*}
{*					<div class="d-flex flex-fill my-1">*}
{*						<div class="form-check-label d-flex me-2">*}
{*							<i class="ph-sun ph-lg me-3"></i>*}
{*							<div>*}
{*								<span class="fw-bold">Light theme</span>*}
{*								<div class="fs-sm text-muted">Set light theme or reset to default</div>*}
{*							</div>*}
{*						</div>*}
{*						<input type="radio" class="form-check-input cursor-pointer ms-auto" name="main-theme" value="light" checked>*}
{*					</div>*}
{*				</label>*}

{*				<label class="list-group-item list-group-item-action form-check border-width-1 rounded mb-2">*}
{*					<div class="d-flex flex-fill my-1">*}
{*						<div class="form-check-label d-flex me-2">*}
{*							<i class="ph-moon ph-lg me-3"></i>*}
{*							<div>*}
{*								<span class="fw-bold">Dark theme</span>*}
{*								<div class="fs-sm text-muted">Switch to dark theme</div>*}
{*							</div>*}
{*						</div>*}
{*						<input type="radio" class="form-check-input cursor-pointer ms-auto" name="main-theme" value="dark">*}
{*					</div>*}
{*				</label>*}

{*				<label class="list-group-item list-group-item-action form-check border-width-1 rounded mb-0">*}
{*					<div class="d-flex flex-fill my-1">*}
{*						<div class="form-check-label d-flex me-2">*}
{*							<i class="ph-translate ph-lg me-3"></i>*}
{*							<div>*}
{*								<span class="fw-bold">Auto theme</span>*}
{*								<div class="fs-sm text-muted">Set theme based on system mode</div>*}
{*							</div>*}
{*						</div>*}
{*						<input type="radio" class="form-check-input cursor-pointer ms-auto" name="main-theme" value="auto">*}
{*					</div>*}
{*				</label>*}
{*			</div>*}


{*		</div>*}

{*	</div>*}
	<!-- /demo config -->
	<script>
        // const checkbox = document.querySelector('#remember_check')
        // if (checkbox) {
        //     checkbox.addEventListener('input', (e) => {
        //         e.currentTarget.checked ? (checkbox.value = 1) : (checkbox.value = 0)
        //     })
        // }

	</script>
</body>
</html>
