<form action="{$adminUrl}/settings" method="post" id="settings" autocomplete="off">

    {capture name="buttons"}
	    <button class="btn btn-sm btn-primary" type="submit" name="action" value="save"><i class="ph-floppy-disk me-2"></i>{general:save}</button>
    {/capture}

    {capture name="breadcrumb"}
	    <a href="{$adminUrl}/settings" class="breadcrumb-item">{$title}</a>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}

	<div class="content">

		<div class="card border shadow-sm">
			<div class="card-header d-flex justify-content-between m-0 p-0">
				<ul class="nav nav-tabs nav-tabs-overline nav-tabs-highlight fs-base border-top-0">

					<li class="nav-item">
						<a class="nav-link fs-sm active show" href="#general" data-bs-toggle="tab">
							<div class="d-flex align-items-center">
								<i class="ph-gear bg-primary text-primary bg-opacity-10 rounded p-1 me-2"></i>
								<span class="fw-semibold">{settings:tabs:general}</span>
							</div>
						</a>
					</li>
					<li class="nav-item">
						<a class="nav-link fs-sm" href="#security" data-bs-toggle="tab">
							<div class="d-flex align-items-center">
								<i class="ph-shield-check bg-primary text-primary bg-opacity-10 rounded p-1 me-2"></i>
								<span class="fw-semibold">{settings:tabs:security}</span>
							</div>
						</a>
					</li>
					<li class="nav-item">
						<a class="nav-link fs-sm" href="#contacts" data-bs-toggle="tab">
							<div class="d-flex align-items-center">
								<i class="ph-identification-card bg-primary text-primary bg-opacity-10 rounded p-1 me-2"></i>
								<span class="fw-semibold">{settings:tabs:contact}</span>
							</div>
						</a>
					</li>
					<li class="nav-item">
						<a class="nav-link fs-sm" href="#mail" data-bs-toggle="tab">
							<div class="d-flex align-items-center">
								<i class="ph-envelope bg-primary text-primary bg-opacity-10 rounded p-1 me-2"></i>
								<span class="fw-semibold">{settings:tabs:pochta}</span>
							</div>
						</a>
					</li>
{*					<li class="nav-item">
						<a class="nav-link fs-sm" href="#telegram" data-bs-toggle="tab">
							<div class="d-flex align-items-center">
								<i class="ph-paper-plane-tilt bg-primary text-primary bg-opacity-10 rounded p-1 me-2"></i>
								<span class="fw-semibold">{settings:tabs:telegram}</span>
							</div>
						</a>
					</li>
*}
					<li class="nav-item">
						<a class="nav-link fs-sm" href="#users" data-bs-toggle="tab">
							<div class="d-flex align-items-center">
								<i class="ph-users bg-primary text-primary bg-opacity-10 rounded p-1 me-2"></i>
								<span class="fw-semibold">{settings:tabs:users}</span>
							</div>
						</a>
					</li>
					<li class="nav-item">
						<a class="nav-link fs-sm" href="#image"              data-bs-toggle="tab">
							<div class="d-flex align-items-center">
								<i class="ph-image bg-primary text-primary bg-opacity-10 rounded p-1 me-2"></i>
								<span class="fw-semibold">{settings:tabs:image}</span>
							</div>
						</a>
					</li>
					<li class="nav-item">
						<a class="nav-link fs-sm" href="#comment"            data-bs-toggle="tab">
							<div class="d-flex align-items-center">
								<i class="ph-chat-circle bg-primary text-primary bg-opacity-10 rounded p-1 me-2"></i>
								<span class="fw-semibold">{settings:tabs:comments}</span>
							</div>
						</a>
					</li>
					<li class="nav-item">
						<a class="nav-link fs-sm" href="#cache"              data-bs-toggle="tab">
							<div class="d-flex align-items-center">
								<i class="ph-sliders bg-primary text-primary bg-opacity-10 rounded p-1 me-2"></i>
								<span class="fw-semibold">{settings:tabs:caching}</span>
							</div>
						</a>
					</li>
					<li class="nav-item">
						<a class="nav-link fs-sm" href="#statistic"          data-bs-toggle="tab">
							<div class="d-flex align-items-center">
								<i class="ph-chart-line bg-primary text-primary bg-opacity-10 rounded p-1 me-2"></i>
								<span class="fw-semibold">{settings:tabs:statistics}</span>
							</div>
						</a>
					</li>
{*                    {if $adminManager.userType eq Mnv\Models\Users\UserTypes::DEVELOPER}
	                    <li class="nav-item">
	                        <a class="nav-link fs-sm" href="#update_url" data-bs-toggle="tab">
		                        <div class="d-flex align-items-center">
			                        <i class="ph-arrow-clockwise bg-primary text-primary bg-opacity-10 rounded p-1 me-2"></i>
			                        <span class="fw-semibold">{settings:tabs:updateUrl}</span>
		                        </div>
	                        </a>
	                    </li>
                    {/if}
*}
				</ul>
			</div>

			<div class="card-body m-0 p-0">
				<div class="tab-content mb-0 p-3">
					<div class="tab-pane fade show active" id="general">
						<fieldset class="">

							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Закрыть прием заявок</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" name="settings[accepting_applications]" value="1" {if $config.accepting_applications}checked{/if}>
									</div>
								</div>
							</div>


							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:general:websiteName}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:general:websiteNameOp}</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="text" name="settings[website_name]" value="{$config.website_name}">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:general:websiteTheme}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:general:websiteThemeOp}</span>
								</label>
								<div class="col-lg-6">
                                    {html_options name="settings[theme]" values=$themes output=$themes selected=$config.theme class="form-control form-control-sm select"}
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:regional:websiteLang}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:regional:websiteLangDesc}</span>
								</label>
								<div class="col-lg-6">
									<script type="text/javascript">
                                        lang2charset = {ldelim} {foreach item = charset key = lang from = $languageCharsets name = languageCharsets}
                                            "{$lang}": "{$charset}" {if !$smarty.foreach.languageCharsets.last}, {/if}{/foreach} {rdelim};
									</script>
                                    {html_options options=$languageOptions  name="settings[website_language]" selected=$config.website_language|default:'' onChange="webLanguageOptionChange(this)" class="form-control form-control-sm select"}
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:regional:charset}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:regional:charsetDesc}</span>
								</label>
								<div class="col-lg-6">
                                    {html_options options=$charsetOptions selected=$config.charset|default:'' name="settings[charset]" id="charsetOptions" class="form-control form-control-sm select"}
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:regional:adminLang}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:regional:adminLangDesc}</span>
								</label>
								<div class="col-lg-6">
                                    {html_options options=$adminLangs name="settings[admin_language]" selected=$config.admin_language|default:'' class="form-control form-control-sm select"}
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:regional:timeFormat}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:regional:timeFormatDesc}</span>
								</label>
								<div class="col-lg-6">
                                    {html_options options=$timeformats selected=$config.use_24_hours|default:'' name="settings[use_24_hours]" class="form-control form-control-sm select"}
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:regional:adjustHours}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:regional:adjustHoursDesc}</span>
								</label>
								<div class="col-lg-6">
                                    {html_options options=$langtimezones name="settings[timezone]" id="timezone" selected=$config.timezone|default:'' class="form-control form-control-sm select"}
								</div>
							</div>

                            {* date_format_custom *}
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Формат даты<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:regional:adjustHoursDesc}</span>
								</label>
								<div class="col-lg-6">
									<div class="row">
										<div class="col-md-6">
											<div class="form-group date_custom">
												<div class="form-check mb-2">
													<div class="form-check form-check-inline">
														<input type="radio" class="form-check-input" id="cr_l_i_s_1" name="date_custom" value="%d %B %Y" {if $config.date_format_custom eq '%d %B %Y'}checked{/if} data-value="{$smarty.now|date_format:"%d %B %Y"}">
														<label class="form-check-label" for="cr_l_i_s_1">{$smarty.now|date_format:"%d %B %Y"} <code class="ml-3">%d %B %Y</code></label>
													</div>
												</div>
												<div class="form-check mb-2">
													<div class="form-check form-check-inline">
														<input type="radio" class="form-check-input" id="cr_l_i_s_2"  name="date_custom" value="%d %b %Y" {if $config.date_format_custom eq '%d %b %Y'}checked{/if}  data-value="{$smarty.now|date_format:"%d %b %Y"}">
														<label class="form-check-label" for="cr_l_i_s_2">{$smarty.now|date_format:"%d %b %Y"} <code class="ml-3">%d %b %Y</code></label>
													</div>
												</div>
												<div class="form-check mb-2">
													<div class="form-check form-check-inline">
														<input type="radio" class="form-check-input" id="cr_l_i_s_3" name="date_custom" value="%d.%m.%Y" {if $config.date_format_custom eq '%d.%m.%Y'}checked{/if}  data-value="{$smarty.now|date_format:"%d.%m.%Y"}">
														<label class="form-check-label" for="cr_l_i_s_3">{$smarty.now|date_format:"%d.%m.%Y"} <code class="ml-3">%d.%m.%Y</code></label>
													</div>
												</div>
												<div class="form-check mb-2">
													<div class="form-check form-check-inline">
														<input type="radio" class="form-check-input" id="cr_l_i_s_4" name="date_custom" value="%Y-%m-%d" {if $config.date_format_custom eq '%Y-%m-%d'}checked{/if}  data-value="{$smarty.now|date_format:"%Y-%m-%d"}">
														<label class="form-check-label" for="cr_l_i_s_4">{$smarty.now|date_format:"%Y-%m-%d"} <code class="ml-3">%d.%m.%Y</code></label>
													</div>
												</div>
												<div class="form-check mb-2">
													<div class="form-check form-check-inline">
														<input type="radio" class="form-check-input" id="cr_l_i_s_5" name="date_custom" value="%d/%m/%Y" {if $config.date_format_custom eq '%d/%m/%Y'}checked{/if}  data-value="{$smarty.now|date_format:"%d/%m/%Y"}">
														<label class="form-check-label" for="cr_l_i_s_5">{$smarty.now|date_format:"%d/%m/%Y"} <code class="ml-3">%d/%m/%Y</code></label>
													</div>
												</div>
												<div class="form-check mb-0">
													<div class="form-check form-check-inline">
														<input type="radio" class="form-check-input" id="cr_l_i_s_6" name="date_custom" value="%m/%d/%Y" {if $config.date_format_custom eq '%m/%d/%Y'}checked{/if}  data-value="{$smarty.now|date_format:"%m/%d/%Y"}">
														<label class="form-check-label" for="cr_l_i_s_6">{$smarty.now|date_format:"%m/%d/%Y"} <code class="ml-3">%m/%d/%Y</code></label>
													</div>
												</div>

											</div>
										</div>
										<div class="col-md-6">
											<div class="form-group date_custom">
												<div class="form-check mb-2">
													<div class="form-check form-check-inline">
														<input type="radio" class="form-check-input" id="cr_l_i_s_7" name="date_custom" value="%d %B %Y %H:%M" {if $config.date_format_custom eq '%d %B %Y %H:%M'}checked{/if} data-value="{$smarty.now|date_format:"%d %B %Y %H:%M"}">
														<label class="form-check-label" for="cr_l_i_s_7">{$smarty.now|date_format:"%d %B %Y %H:%M"} <code class="ml-3">%d %B %Y %H:%M</code></label>
													</div>
												</div>
												<div class="form-check mb-2">
													<div class="form-check form-check-inline">
														<input type="radio" class="form-check-input" id="cr_l_i_s_8" name="date_custom" value="%d %b %Y %H:%M" {if $config.date_format_custom eq '%d %b %Y %H:%M'}checked{/if} data-value="{$smarty.now|date_format:"%d %b %Y %H:%M"}">
														<label class="form-check-label" for="cr_l_i_s_8">{$smarty.now|date_format:"%d %b %Y %H:%M"} <code class="ml-3">%d %b %Y %H:%M</code></label>
													</div>
												</div>
												<div class="form-check mb-2">
													<div class="form-check form-check-inline">
														<input type="radio" class="form-check-input" id="cr_l_i_s_9" name="date_custom" value="%d.%m.%Y %H:%M" {if $config.date_format_custom eq '%d.%m.%Y %H:%M'}checked{/if} data-value="{$smarty.now|date_format:"%d.%m.%Y %H:%M"}">
														<label class="form-check-label" for="cr_l_i_s_9">{$smarty.now|date_format:"%d.%m.%Y %H:%M"} <code class="ml-3">%d.%m.%Y %H:%M</code></label>
													</div>
												</div>
												<div class="form-check mb-2">
													<div class="form-check form-check-inline">
														<input type="radio" class="form-check-input" id="cr_l_i_s_10" name="date_custom" value="%Y-%m-%d %H:%M" {if $config.date_format_custom eq '%Y-%m-%d %H:%M'}checked{/if} data-value="{$smarty.now|date_format:"%Y-%m-%d %H:%M"}">
														<label class="form-check-label" for="cr_l_i_s_10">{$smarty.now|date_format:"%Y-%m-%d %H:%M"} <code class="ml-3">%Y-%m-%d %H:%M</code></label>
													</div>
												</div>
												<div class="form-check mb-2">
													<div class="form-check form-check-inline">
														<input type="radio" class="form-check-input" id="cr_l_i_s_11" name="date_custom" value="%d/%m/%Y %H:%M" {if $config.date_format_custom eq '%d/%m/%Y %H:%M'}checked{/if} data-value="{$smarty.now|date_format:"%d/%m/%Y %H:%M"}">
														<label class="form-check-label" for="cr_l_i_s_11">{$smarty.now|date_format:"%d/%m/%Y %H:%M"} <code class="ml-3">%d/%m/%Y %H:%M</code></label>
													</div>
												</div>
												<div class="form-check mb-0">
													<div class="form-check form-check-inline">
														<input type="radio" class="form-check-input" id="cr_l_i_s_12" name="date_custom" value="%m/%d/%Y %H:%M" {if $config.date_format_custom eq '%m/%d/%Y %H:%M'}checked{/if} data-value="{$smarty.now|date_format:"%m/%d/%Y %H:%M"}">
														<label class="form-check-label" for="cr_l_i_s_12">{$smarty.now|date_format:"%m/%d/%Y %H:%M"} <code class="ml-3">%m/%d/%Y %H:%M</code></label>
													</div>
												</div>

											</div>
										</div>
										<div class="col-md-12">
											<div class="form-check input-group mt-2">
												<div class="form-check form-check-inline">
													<input type="radio" class="form-check-input" id="cr_l_i_s_13"  name="date_custom" value="" {if $config.date_format_custom ne '%d %B %Y' AND $config.date_format_custom ne '%d %b %Y' AND $config.date_format_custom ne '%d.%m.%Y' AND $config.date_format_custom ne '%Y-%m-%d' AND $config.date_format_custom ne '%d/%m/%Y' AND $config.date_format_custom ne '%m/%d/%Y' AND $config.date_format_custom ne '%d %B %Y %H:%M' AND $config.date_format_custom ne '%d %b %Y %H:%M' AND $config.date_format_custom ne '%d.%m.%Y %H:%M' AND $config.date_format_custom ne '%Y-%m-%d %H:%M' AND $config.date_format_custom ne '%d/%m/%Y %H:%M' AND $config.date_format_custom ne '%m/%d/%Y %H:%M'} checked{/if}>
													<label class="form-check-label" for="cr_l_i_s_13">Произвольно: <input type="text" class="form-control m-n2 date_format_custom" placeholder="Date format " name="settings[date_format_custom]" value="{$config.date_format_custom}" style="max-width: 150px"></label>
												</div>
											</div>
											<div class="input-group mt-2">
												<span class="font-weight-semibold mt-2">Предварительный просмотр: <span class="date_format_custom_real">{$smarty.now|date_format:$config.date_format_custom}</span></span>
											</div>
										</div>
									</div>
								</div>

							</div>


							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:regional:mask}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:regional:maskDesc}</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="text" name="settings[phone_mask]" value="{$config.phone_mask}">
								</div>
							</div>

							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Лента инстаграм (токен)<br />
									<span class="p-0 font-size-sm font-italic text-muted">Использовать если присутствует лента согласно дизайну</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="text" name="settings[instagram_token]" value="{$config.instagram_token}">
								</div>
							</div>


							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:general:websiteDown}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:general:websiteDownOp}</span>
								</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" id="website_down"  name="settings[website_down]" value="1" {if $config.website_down}checked{/if}>
										<label class="form-check-label" for="website_down">{settings:general:websiteDown}</label>
									</div>
								</div>
							</div>

							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:general:websiteDownMsg}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:general:websiteDownMsgOp}</span>
								</label>
								<div class="col-lg-6">
									<textarea rows="5" cols="3" class="form-control" name="settings[maintenance_message]" >{$config.maintenance_message}</textarea>
								</div>
							</div>
						</fieldset>
					</div>

					<div class="tab-pane fade" id="security">
						<fieldset class="">

							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:general:listip}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:general:listipInfo} <b>{$ADMINIP}</b></span>
								</label>
								<div class="col-lg-6">
									<input type="text" class="form-control tokenfield" placeholder="Add ip"  name="settings[listIp]" value="{$config.listIp}" data-fouc>
								</div>
							</div>

							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Всегда использовать HTTPS протокол<br />
									<span class="p-0 font-size-sm font-italic text-muted">В случае включения данной настройки, пользователи которые заходят на ваш сайт по обычному HTTP протоколу,<br>
										будут автоматически перенаправлены на использование защищенного SSL соединения.</span>
								</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" name="settings[only_ssl]" value="1" {if $config.only_ssl}checked{/if}>
									</div>
								</div>
							</div>

							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Блокировать пользователей пытавшихся подобрать пароль к входу</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" name="settings[check_banned_ips]" value="1" {if $config.check_banned_ips}checked{/if}>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Тестировать сайт на ошибки</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" name="settings[error_test]" value="1" {if $config.error_test}checked{/if}>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:general:feedbackCaptcha}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:general:feedbackCaptchaOp}</span>
								</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" name="settings[feedback_captcha_enabled]" value="1" {if $config.feedback_captcha_enabled}checked{/if}>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:general:feedbackTypeCaptcha}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:general:feedbackTypeCaptchaOp}</span>
								</label>
								<div class="col-lg-6">
                                    {html_options options=$captchas name="settings[allow_recaptcha]" selected=$config.allow_recaptcha class="form-control form-control-sm select"}
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:general:recaptchaPublicKey}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:general:recaptchaPublicKeyOp}</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="text" name="settings[recaptcha_public_key]" value="{$config.recaptcha_public_key}">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:general:recaptchaSecretKey}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:general:recaptchaSecretKeyOp}</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="text" name="settings[recaptcha_private_key]" value="{$config.recaptcha_private_key}">
								</div>
							</div>
						</fieldset>
					</div>

					<div class="tab-pane fade" id="contacts">
						<fieldset class="">
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:general:companyName}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:general:companyNameOp}</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="text" name="settings[company_name]" value="{$config.company_name}">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:general:operatingMode}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:general:operatingModeOp}</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="text" name="settings[operating_mode]" value="{$config.operating_mode}">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:general:address}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:general:addressOp}</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="text" name="settings[address]" value="{$config.address}">
								</div>
							</div>
                            {*    						<div class="row mb-3">*}
                            {*    							<label class="col-form-label col-lg-6">*}
                            {*        							{settings:general:feedbackEmail}*}
                            {*        							<span class="p-0 font-size-sm font-italic text-muted">{settings:general:feedbackEmailOp}</span>*}
                            {*    							</label>*}
                            {*    							<div class="col-lg-6">*}
                            {*    								<input class="form-control" type="text" name="settings[feedback_email]" value="{$config.feedback_email}">*}
                            {*    							</div>*}
                            {*    						</div>*}

							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:general:phone}</label>
								<div class="col-lg-6"><input class="form-control" type="text" name="settings[phone]" value="{$config.phone}"></div>
							</div>
                            {*	                        <div class="row mb-3">*}
                            {*		                        <label class="col-form-label col-lg-6">Дополнительный телефон</label>*}
                            {*		                        <div class="col-lg-6"><input class="form-control" type="text" name="settings[additional_phone]" value="{$config.additional_phone}"></div>*}
                            {*	                        </div>*}
                            {*    						<div class="row mb-3">*}
                            {*    							<label class="col-form-label col-lg-6">{settings:general:phoneTwo}</label>*}
                            {*    							<div class="col-lg-6"><input class="form-control" type="text" name="settings[phone_two]" value="{$config.phone_two}"></div>*}
                            {*    						</div>*}
                            {*    						<div class="row mb-3">*}
                            {*    							<label class="col-form-label col-lg-6">{settings:general:phoneThree}</label>*}
                            {*    							<div class="col-lg-6"><input class="form-control" type="text" name="settings[phone_three]" value="{$config.phone_three}"></div>*}
                            {*    						</div>*}
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Дополнительный email</label>
								<div class="col-lg-6"><input class="form-control" type="text" name="settings[support_email]" value="{$config.support_email}"></div>
							</div>
						</fieldset>
					</div>

					<div class="tab-pane fade" id="mail">
						<fieldset class="mb-4">
							<legend class="fs-base fw-bold border-bottom pb-2 mb-3"><i class="ph-envelope-open me-2"></i>{settings:tabs:pochta}</legend>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
									Тестирование <br />
									<span class="p-0 font-size-sm font-italic text-muted">Тестирование почты при настройки SMTP, только для разработчиков</span>
								</label>
								<div class="col-lg-6">
									<select class="form-control form-select-sm select" name="settings[smtp_debug]">
										<option value="0" {if $config.smtp_debug eq 0}selected{/if}>0</option>
										<option value="1" {if $config.smtp_debug eq 1}selected{/if}>1</option>
										<option value="2" {if $config.smtp_debug eq 2}selected{/if}>2</option>
										<option value="3" {if $config.smtp_debug eq 3}selected{/if}>3</option>
										<option value="4" {if $config.smtp_debug eq 4}selected{/if}>4</option>
									</select>
                                    {*							        <input class="form-control" type="text" autocomplete="off" name="settings[smtp_debug]" value="{$config.smtp_debug}">*}
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:mails:smtp_transport}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:mails:smtp_transportOp}</span>
								</label>
								<div class="col-lg-6">
                                    {html_options options=$mailTransports selected=$config.mail_transport|default:'' name="settings[mail_transport]" class="form-control form-control-sm select"}
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:mails:smtp_subject}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:mails:smtp_subjectOp}</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="text" autocomplete="off" name="settings[smtp_subject]" value="{$config.smtp_subject}">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:mails:smtp_email}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:mails:smtp_emailOp}</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="text" autocomplete="off" name="settings[email]" value="{$config.email}" placeholder="noreply@example.com">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:mails:smtp_server}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:mails:smtp_serverOp}</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="text" autocomplete="off" name="settings[smtp_server]" value="{$config.smtp_server}" placeholder="smtp.example.com">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:mails:smtp_user}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:mails:smtp_userOp}</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="text" autocomplete="off" name="settings[smtp_user]" value="{$config.smtp_user}" placeholder="user@example.com">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:mails:smtp_pass}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:mails:smtp_passOp}</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" autocomplete="off" type="password" name="settings[smtp_pass]" value="{$config.smtp_pass}" id="password">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:mails:smtp_port}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:mails:smtp_portOp}</span>
								</label>
								<div class="col-lg-6">
                                    {html_options options=$ports selected=$config.smtp_port|default:'' name="settings[smtp_port]" id="ports" class="form-control form-control-sm select"}
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:mails:smtp_secure}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:mails:smtp_secureOp}</span>
								</label>
								<div class="col-lg-6">
                                    {html_options options=$secures selected=$config.smtp_secure|default:'' name="settings[smtp_secure]" id="secures" class="form-control form-control-sm select"}
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
									E-mail для авторизации на SMTP сервере в качестве отправителя<br />
									<span class="p-0 font-size-sm font-italic text-muted">Данная настройка является необязательной,
								        однако некоторые бесплатные почтовые сервисы, например yandex.ru,
								        требуют, чтобы в качестве E-mail адреса отправителя был указан именно адрес, зарегистрированный на их почтовом сервисе.</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="text" autocomplete="off" name="settings[smtp_mail]" value="{$config.smtp_mail}" placeholder="user@example.com">
								</div>
							</div>
{*							<div class="row mb-3">*}
{*								<label class="col-form-label col-lg-6">*}
{*									Использовать поле BCC для рассылки<br />*}
{*									<span class="p-0 font-size-sm font-italic text-muted">Если вы выберете 'Включено' то при рассылке сообщений в качестве получателей будет указано несколько адресатов, что позволяет сократить общее время отправки сообщений и количество отправленных сообщений.</span>*}
{*								</label>*}
{*								<div class="col-lg-6">*}
{*									<div class="form-check form-switch mb-2">*}
{*										<input type="checkbox" class="form-check-input" name="settings[mail_bcc]" value="1" {if $config.mail_bcc}checked{/if}>*}
{*									</div>*}
{*								</div>*}
{*							</div>*}
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Проверка соединения с SMTP сервером</label>
								<div class="col-lg-6">
									<div class="input-group">
										<button class="btn btn-sm btn-primary control-cache fn_test_smtp" type="button">Проверить соединение</button>
										<span class="input-group-text fn_test_smtp_status collapse"></span>
									</div>
								</div>
							</div>
							<div class="form-group">
								<div class="fn_test_smtp_trace"></div>
							</div>

						</fieldset>
					</div>

					<div class="tab-pane fade" id="users">
						<fieldset class="">
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:users:methodAuth}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:users:methodAuthText}</span>
								</label>
								<div class="col-lg-6">
                                    {html_options options=$methods selected=$config.methodAuth|default:'' name="settings[methodAuth]" id="methodAuth" class="form-control select"}
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:users:maxUserDay}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:users:maxUserDayText}</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="text" autocomplete="off" name="settings[maxUserDay]" value="{if isset($config.maxUserDay)}{$config.maxUserDay}{/if}">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:users:twoFactorAuth}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:users:twoFactorAuthText}</span>
								</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" name="settings[twoFactorAuth]" value="1" {if $config.twoFactorAuth}checked{/if}>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:users:smsUrl}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:users:smsLoginInfo}</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="text" autocomplete="off" name="settings[sms_url]" value="{$config.sms_url|default:''}" placeholder="http://91.204.239.44/broker-api/send">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:users:smsLogin}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:users:smsLoginInfo}</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="text" autocomplete="off" name="settings[sms_login]" value="{$config.sms_login|default:""}" placeholder="*********">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:users:smsPassword}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:users:smsLoginInfo}</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="password" autocomplete="off" name="settings[sms_password]" value="{$config.sms_password|default:''}" placeholder="*********">
								</div>
							</div>
						</fieldset>
					</div>

{*					<div class="tab-pane fade" id="telegram">
						<fieldset class="">
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:telegrams:enabled}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:telegrams:enabledOp}</span>
								</label>
								<div class="col-lg-6">
                                                                        {html_options options=$works name="settings[telegram_send]" id="telegram_send" selected=$config.telegram_send|default:1 class="form-control form-control-sm select"}
									<div class="form-check form-check-switchery">
										<label class="form-check-label">
											<input type="checkbox" class="form-check-input-switchery" name="settings[telegram_send]" value="1" {if $config.telegram_send}checked{/if} data-fouc>
										</label>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:telegrams:token}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:telegrams:tokenOp}</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="text" autocomplete="off" name="settings[telegram_token]" value="{$config.telegram_token}">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">
                                    {settings:telegrams:chatId}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:telegrams:chatIdOp}</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="text" autocomplete="off" name="settings[telegram_chat_id]" value="{$config.telegram_chat_id}">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6" style="padding-top: 60px">
                                    {settings:telegrams:howToConnect}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:telegrams:howToConnectOp}</span>
								</label>
								<div class="col-lg-6"><p><img src="/admin/assets/images/telegram/telegram-1.jpg" style="width: 250px;"></p></div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6" style="padding-top: 60px"><span class="p-0 font-size-sm font-italic text-muted">{settings:telegrams:connectMessage}</span></label>
								<div class="col-lg-6"><p><img src="/admin/assets/images/telegram/telegram-2.jpg" style="width: 250px;"></p></div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6" style="padding-top: 30px"><span class="p-0 font-size-sm font-italic text-muted">{settings:telegrams:botEnabled}</span></label>
								<div class="col-lg-6"><p><img src="/admin/assets/images/telegram/telegram-3.jpg" style="width: 250px;"></p></div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6" style="padding-top: 0px"><span class="p-0 font-size-sm font-italic text-muted">{settings:telegrams:doneRight}</span></label>
								<div class="col-lg-6">
									<code style="color: #2554c7;background: none"> {
										"ok":true,
										"result":[ <br>
										&nbsp;&nbsp; { <br>
										&nbsp;&nbsp;&nbsp;&nbsp;"update_id":434540657,<br>
										&nbsp;&nbsp;&nbsp;&nbsp;"message": { <br>
										&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"message_id":2,<br>
										&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"from": { <br>
										&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"id":<font color="#FF0000">698237240</font>,<br>
										&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"is_bot":false,<br>
										&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"first_name":"Ivanov",<br>
										&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"language_code":"ru"<br>
										&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; } ,<br>
										&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"chat": { <br>
										&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"id":<font color="#FF0000">698237240</font>,<br>
										&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"first_name":"Ivanov",<br>
										&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"type":"private"<br>
										&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; } ,<br>
										&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"date":1536053889,<br>
										&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"text":"Hello"<br>
										&nbsp;&nbsp;&nbsp;&nbsp; } <br>
										&nbsp;&nbsp; } <br>
										] } <br>
									</code>
								</div>
							</div>

						</fieldset>
					</div>
*}

					<div class="tab-pane fade" id="image">
						<fieldset class="mb-3">
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Обработчик загружаемых изображений<br />
									<span class="p-0 font-size-sm font-italic text-muted">Выберите PHP библиотеку, которая будет обрабатывать изображения.</span>
								</label>
								<div class="col-lg-6">
                                    {html_options options=$imageGenerations selected=$config.image_generation|default:'imagine' name="settings[image_generation]" id="imageGenerations" class="form-control form-control-sm select"}
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Драйвер обработки загружаемых изображений<br />
									<span class="p-0 font-size-sm font-italic text-muted">Выберите PHP библиотеку, которая будет обрабатывать изображения, загружаемые на сервер.</span>
								</label>
								<div class="col-lg-6">
                                    {html_options options=$driver selected=$config.image_library|default:0 name="settings[image_library]" id="imageLibrary" class="form-control form-control-sm select"}
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Переводить все загружаемые изображения в формат WebP<br />
									<span class="p-0 font-size-sm font-italic text-muted">При включении данной настройки, все изображения, загружаемые на сервер, независимо от их формата и расширения,
				                        будут автоматически перекодированы в формат изображения WebP.<br />
				                        Данный формат является прогрессивным и позволяет создавать более качественные изображения при их меньшем размере.
				                        Однако показ изображений в данном формате требует наличия у пользователей современного браузера.
			                        </span>
								</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" name="settings[force_webp]" value="1" {if $config.force_webp}checked{/if}>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Максимальный размер файла допустимый к загрузке на сервер (в мегабайтах)<br />
									<span class="p-0 font-size-sm font-italic text-muted">Введите максимальный размер файлов которые допустимо загружать на сервер.<br />
				                        Данный размер указывается в килобайтах, например для ограничения размера файла в 2 мегабайта, в настройках указывается 2048. <br />
				                        Если вы хотите снять ограничение, то укажите в настройках 0.</span></label>
								<div class="col-lg-6">
									<input class="form-control" type="text" name="settings[max_file_size]" value="{$config.max_file_size}">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Максимально допустимый вес изображений, загружаемых для контента<br />
									<span class="p-0 font-size-sm font-italic text-muted">Введите максимальный объём загружаемого изображения (в мегабайтах)</span></label>
								<div class="col-lg-6">
									<input class="form-control" type="text" name="settings[max_up_size]" value="{$config.max_up_size}">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Размер маленькой превью копии загруженного изображения<br />
									<span class="p-0 font-size-sm font-italic text-muted">Существует две возможности использования данной настройки:<br />
									    Первая: Вы задаете максимальный размер в пикселях любой из сторон загружаемой картинки при превышении которого будет создаваться уменьшенная копия. Например: 400<br />
									    Вторая: Вы задаете ширину и высоту уменьшенной копии изображения в формате ширина x высота. Например: 100x100.<br />
									    Вы можете указать 0, если не хотите создавать превью копии загружаемых картинок на сервер.</span>
								</label>
								<div class="col-lg-6">
									<div class="row">
										<div class="col-md-5"><input type="text" name="settings[small_thumb]" value="{$config.small_thumb}" class="form-control"></div>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Размер средней копии загруженного изображения<br />
									<span class="p-0 font-size-sm font-italic text-muted">Существует две возможности использования данной настройки:<br />
									    Первая: Вы задаете максимальный размер в пикселях любой из сторон загружаемой картинки при превышении которого будет создаваться уменьшенная копия. Например: 400<br />
									    Вторая: Вы задаете ширину и высоту уменьшенной копии изображения в формате ширина x высота. Например: 100x100.<br />
									    Вы можете указать 0, если не хотите создавать превью копии загружаемых картинок на сервер.</span>
								</label>
								<div class="col-lg-6">
									<div class="row">
										<div class="col-md-5"><input type="text" name="settings[medium_thumb]" value="{$config.medium_thumb}" class="form-control"></div>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Размер большой копии загруженного изображения<br />
									<span class="p-0 font-size-sm font-italic text-muted">Существует две возможности использования данной настройки:<br />
									    Первая: Вы задаете максимальный размер в пикселях любой из сторон загружаемой картинки при превышении которого будет создаваться уменьшенная копия. Например: 400<br />
									    Вторая: Вы задаете ширину и высоту уменьшенной копии изображения в формате ширина x высота. Например: 100x100.<br />
									    Вы можете указать 0, если не хотите создавать превью копии загружаемых картинок на сервер.</span>
								</label>
								<div class="col-lg-6">
									<div class="row">
										<div class="col-md-5"><input type="text" name="settings[large_thumb]" value="{$config.large_thumb}" class="form-control"></div>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:article:thumbQuality}</label>
								<div class="col-lg-6">
									<div class="row">
										<div class="col-md-5">
                                            {html_options options=$thumbQualityOptions name="settings[thumbnail_quality]" selected=$config.thumbnail_quality class="form-control form-control-sm select"}
										</div>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:article:keepImageName}</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" name="settings[keep_original_image_name]" value="1" {if $config.keep_original_image_name}checked{/if}>
									</div>
								</div>
							</div>
                            {*    						<div class="row mb-3">*}
                            {*    							<label class="col-form-label col-lg-6">{settings:article:saveThumbnailImage}</label>*}
                            {*    							<div class="col-lg-6">*}
                            {*    								<div class="form-check form-check-switchery">*}
                            {*                                        <label class="form-check-label">*}
                            {*                                            <input type="checkbox" class="form-check-input-switchery" name="settings[save_thumbnail_image]" value="1" {if $config.save_thumbnail_image}checked{/if} data-fouc>*}
                            {*                                        </label> *}
                            {*                    			    </div>*}
                            {*    							</div>*}
                            {*    						</div>*}
						</fieldset>
						<fieldset>
							<legend class="text-uppercase font-size-sm font-weight-bold">Водяной знак на картинку
							</legend>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Разрешить наложение водяных знаков<br />
									<span class="p-0 font-size-sm font-italic text-muted">При загрузке или копировании картинки на сервер, на нее будет наложен водяной знак</span>
								</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" name="settings[allow_watermark]" value="1" {if $config.allow_watermark}checked{/if}>
									</div>
								</div>
							</div>
                            {*						    <div class="row mb-3">*}
                            {*							    <label class="col-form-label col-lg-6">Минимальный размер для накладывания водяного знака<br />*}
                            {*								    <i>Минимальный размер любой из сторон изображения, до которого водяной знак накладываться не будет</i></label>*}
                            {*							    <div class="col-lg-6">*}
                            {*								    <input class="form-control" type="text" name="settings[max_watermark]" value="{$config.max_watermark}">*}
                            {*							    </div>*}
                            {*						    </div>*}
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Область наложения водяного знака<br />
									<span class="p-0 font-size-sm font-italic text-muted">Укажите область на оригинальном изображении на которую будет накладываться водяной знак для загружаемого изображения</span>
								</label>
								<div class="col-lg-6">
									<select class="form-control form-select-sm select" name="settings[watermark_position]">
										<option value="TOP LEFT"{if $config.watermark_position eq 'TOP LEFT'}selected{/if}>Сверху слева</option>
										<option value="TOP RIGHT" {if $config.watermark_position eq 'TOP RIGHT'}selected{/if}>Сверху справа</option>
										<option value="BOTTOM LEFT" {if $config.watermark_position eq 'BOTTOM LEFT'}selected{/if}>Снизу слева</option>
										<option value="BOTTOM RIGHT" {if $config.watermark_position eq 'BOTTOM RIGHT'}selected{/if}>Снизу справа</option>
										<option value="CENTER CENTER" {if $config.watermark_position eq 'CENTER CENTER'}selected{/if}>По центру</option>
									</select>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Тип водяного знака<br />
									<span class="p-0 font-size-sm font-italic text-muted">Укажите тип накладываемого водяного знака. Это может быть изображение, расположенное в шаблоне, либо может быть текст, написанный в настройках ниже</span>
								</label>
								<div class="col-lg-6">
									<select class="form-control select" name="settings[watermark_type]">
										<option value="0"{if $config.watermark_type eq 0}selected{/if}>Изображение из шаблона</option>
										<option value="1" {if $config.watermark_type eq 1}selected{/if}>Текст</option>
									</select>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Текст для водяного знака<br />
									<span class="p-0 font-size-sm font-italic text-muted">Укажите текст водяного знака, который будет накладываться на изображения, в случае если вы включили тип водяного знака: 'Текст'</span></label>
								<div class="col-lg-6">
									<input class="form-control" type="text" name="settings[watermark_text]" value="{$config.watermark_text}">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Размер шрифта для водяного знака<br />
									<span class="p-0 font-size-sm font-italic text-muted">Укажите размер шрифта для водяного знака, в случае если вы включили тип водяного знака: 'Текст'. Указывается числовое значение, например: 16</span></label>
								<div class="col-lg-6">
									<input class="form-control" type="text" name="settings[watermark_font]" value="{$config.watermark_font}">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Цвет текста водяного знака для светлых изображений<br />
									<span class="p-0 font-size-sm font-italic text-muted">Укажите цвет текста водяного знака для светлых изображений, в случае если вы включили тип водяного знака: 'Текст'. Например, для указания чёрного цвета укажите: #000000</span></label>
								<div class="col-lg-6">
									<input class="form-control" type="text" name="settings[watermark_color_dark]" value="{$config.watermark_color_dark}">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Угол поворота водяного знака<br />
									<span class="p-0 font-size-sm font-italic text-muted">Вы можете указать угол для поворота водяного знака. Поворот применяется к изображению водяного знака и к тексту</span>
								</label>
								<div class="col-lg-6">
									<select class="form-control select" name="settings[watermark_rotate]">
										<option value="0"{if $config.watermark_rotate eq 0}selected{/if}>Отсутствует</option>
										<option value="90" {if $config.watermark_rotate eq '90'}selected{/if}>Наверх 90 градусов</option>
										<option value="45" {if $config.watermark_rotate eq '45'}selected{/if}>Наверх 45 градусов</option>
										<option value="-45" {if $config.watermark_rotate eq '-45'}selected{/if}>Вниз 45 градусов</option>
										<option value="-90" {if $config.watermark_rotate eq '-90'}selected{/if}>Вниз 90 градусов</option>
									</select>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Цвет текста водяного знака для темных изображений<br />
									<span class="p-0 font-size-sm font-italic text-muted">Укажите цвет текста водяного знака для темных изображений, в случае если вы включили тип водяного знака: 'Текст'. Например, для указания чёрного цвета укажите: #ffffff</span></label>
								<div class="col-lg-6">
									<input class="form-control" type="text" name="settings[watermark_color_light]" value="{$config.watermark_color_light}">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Прозрачность водяного знака<br />
									<span class="p-0 font-size-sm font-italic text-muted">Вы можете указать прозрачность для водяного знака. Прозрачность применяется к изображению водяного знака и к тексту. Указывается число от 0 до 100, где 0 это полная прозрачность, а 100 полная непрозрачность</span></label>
								<div class="col-lg-6">
									<input class="form-control" type="text" name="settings[watermark_opacity]" value="{$config.watermark_opacity}">
								</div>
							</div>
						</fieldset>
					</div>

					<div class="tab-pane fade" id="comment">
						<fieldset class="mb-3">
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:comments:enabledByDefault}</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" name="settings[comments_enabled]" value="1" {if $config.comments_enabled}checked{/if}>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:comments:editorsApprove}</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" name="settings[comments_editors_may_approve]" value="1" {if $config.comments_editors_may_approve}checked{/if}>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:comments:requireCaptcha}</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" name="settings[comments_captcha_enabled]" value="1" {if $config.comments_captcha_enabled}checked{/if}>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:comments:contentModeration}</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" id="comments_strip_html" name="settings[comments_strip_html]" value="1" {if $config.comments_strip_html}checked{/if} >
										<label class="form-check-label" for="comments_strip_html">{settings:comments:stripTags}</label>
									</div>
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" id="comments_strip_html" name="settings[comments_strip_html]" value="1" {if $config.comments_strip_html}checked{/if} >
										<label class="form-check-label" for="comments_strip_html">{settings:comments:convertUrls}</label>
									</div>

								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:comments:emailConfirmation}</label>
								<div class="col-lg-6">
									<div class="form-check mb-2">
										<input type="radio" class="form-check-input" id="comments_email_confirmation_required_0" name="settings[comments_email_confirmation_required]" value="0" {if $config.comments_email_confirmation_required == 0}checked{/if} >
										<label class="form-check-label" for="comments_email_confirmation_required_0">{settings:comments:noConfirmation}</label>
									</div>
									<div class="form-check mb-2">
										<input type="radio" class="form-check-input" id="comments_email_confirmation_required_1" name="settings[comments_email_confirmation_required]" value="1" {if $config.comments_email_confirmation_required == 1}checked{/if} >
										<label class="form-check-label" for="comments_email_confirmation_required_1">{settings:comments:confirmationFirstTime}</label>
									</div>
									<div class="form-check mb-2">
										<input type="radio" class="form-check-input" id="comments_email_confirmation_required_2" name="settings[comments_email_confirmation_required]" value="2" {if $config.comments_email_confirmation_required == 2}checked{/if} >
										<label class="form-check-label" for="comments_email_confirmation_required_2">{settings:comments:confirmationEachTime}</label>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:comments:commentModeration}</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" id="comments_must_be_approved" name="settings[comments_must_be_approved]" value="1" {if $config.comments_must_be_approved}checked{/if} >
										<label class="form-check-label" for="comments_must_be_approved">{settings:comments:manualApprove}</label>
									</div>
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" id="comments_whitelist_enabled" name="settings[comments_whitelist_enabled]" value="1" {if $config.comments_whitelist_enabled}checked{/if} >
										<label class="form-check-label" for="comments_whitelist_enabled">{settings:comments:avoidApprove}</label>
									</div>
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" id="comments_blacklist_enabled" name="settings[comments_blacklist_enabled]" value="1" {if $config.comments_blacklist_enabled}checked{/if} >
										<label class="form-check-label" for="comments_blacklist_enabled">{settings:comments:markAsSpam}</label>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:comments:holdComment}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:comments:markCommentText}</span></label>
								<div class="col-lg-6">
									<textarea name="settings[comments_hold_words]" class="form-control" rows="5">{$config.comments_hold_words}</textarea>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:comments:markComment}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:comments:markCommentText}</span></label>
								<div class="col-lg-6">
									<textarea name="settings[comments_spam_words]" class="form-control" rows="5">{$config.comments_spam_words}</textarea>
								</div>
							</div>

						</fieldset>
					</div>

					<div class="tab-pane fade" id="cache">
						<fieldset class="mb-3">
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:miscellaneous:compress}<br>
									<span class="p-0 font-size-sm font-italic text-muted">{settings:miscellaneous:compressText}</span>
								</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" name="settings[compress_js_css]" value="1" {if $config.compress_js_css}checked{/if}>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Сжимает содержимое до того,как оно будет доставлено клиенту. (mod_deflate)<br />
									<span class="p-0 font-size-sm font-italic text-muted">Модуль <code class="p-0">mod_deflate</code> предоставляет выходной фильтр   <code class="p-0">DEFLATE</code>, который позволяет сжимать выходные данные с вашего сервера перед отправкой клиенту по сети.</span></label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" name="settings[mod_deflate]" value="1" {if $config.mod_deflate}checked{/if}>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Настройка заголовков HTTP-запросов и ответов (mod_headers)<br />
									<span class="p-0 font-size-sm font-italic text-muted">Этот модуль предоставляет директивы для управления и изменения заголовков HTTP-запросов и ответов.<br />
				                        Заголовки могут быть объединены,заменены или удалены.</span>
								</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" name="settings[mod_headers]" value="1" {if $config.mod_headers}checked{/if}>
									</div>
								</div>
							</div>

							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Генерация HTTP-заголовков Expires и Cache-Control в соответствии с заданными пользователем критериями (mod_expires)<br />
									<span class="p-0 font-size-sm font-italic text-muted">Этот модуль управляет настройкой HTTP-заголовка Expires и директивы max-age HTTP-заголовка Cache-Control в ответах сервера. <br />
			                        Дата истечения срока может быть установлена относительно времени последнего изменения исходного файла или времени доступа клиента.<br />
			                        Поддерживается не на всех хостингах</span>
								</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" name="settings[mod_expires]" value="1" {if $config.mod_expires}checked{/if}>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Редирект с www на без www.<br />
									<span class="p-0 font-size-sm font-italic text-muted">www.example.org - example.org</span>
								</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" name="settings[www_redirect]" value="1" {if $config.www_redirect}checked{/if}>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">Редирект http <-> https.<br />
									<span class="p-0 font-size-sm font-italic text-muted">http://example.org <-> https://example.org</span>
								</label>
								<div class="col-lg-6">
									<label class="form-check mb-2">
										<input type="radio" class="form-check-input" name="settings[http_redirect]" value="0" {if !isset($config.http_redirect) || $config.http_redirect eq 0}checked{/if}>
										<span class="form-check-label">Не использовать</span>
									</label>

									<label class="form-check mb-2">
										<input type="radio" class="form-check-input" name="settings[http_redirect]" value="1" {if isset($config.http_redirect) && $config.http_redirect eq 1}checked{/if}>
										<span class="form-check-label">на https://*</span>
									</label>

									<label class="form-check mb-2">
										<input type="radio" class="form-check-input" name="settings[http_redirect]" value="2" {if isset($config.http_redirect) && $config.http_redirect eq 2}checked{/if}>
										<span class="form-check-label">на http://*</span>
									</label>
								</div>
							</div>


							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:miscellaneous:extension}</label>
								<div class="col-lg-6">
                                    {html_options options=$fileExtension name="settings[file_extension]" selected=$config.file_extension class="form-control form-control-sm select"}
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:miscellaneous:convert}</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" name="settings[convert_filename_to_lowercase]" value="1" {if $config.convert_filename_to_lowercase}checked{/if}>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:miscellaneous:separator}</label>
								<div class="col-lg-6">
                                    {html_options options=$separators name="settings[filename_word_separator]" selected=$config.filename_word_separator class="form-control form-control-sm select"}
								</div>
							</div>

							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:caching:sections}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:caching:sectionsText}</span>
								</label>
								<div class="col-lg-3">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" id="cache_enabled_section" name="settings[cache_enabled_section]" value="1" {if $config.cache_enabled_section}checked{/if}>
										<label class="form-check-label" for="cache_enabled_section">{general:enableCachingFor}</label>
									</div>
								</div>
								<div class="col-md-3 col-xs-2">
									<div class="input-group">
	                                    {html_options options=$cachingTimeOptions name="settings[cache_time_section]" selected=$config.cache_time_section class="form-control form-control-sm select" data-width="1%"}
	                                    {html_options options=$cachingPeriodOptions name="settings[cache_period_section]" selected=$config.cache_period_section class="form-control form-control-sm select" data-width="1%"}
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:caching:articles}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:caching:articlesText}</span>
								</label>
								<div class="col-lg-3">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" id="cache_enabled_section" name="settings[cache_enabled_article]" value="1" {if $config.cache_enabled_article}checked{/if}>
										<label class="form-check-label" for="cache_enabled_section">{general:enableCachingFor}</label>
									</div>
								</div>
								<div class="col-md-3 col-xs-2">
									<div class="input-group">
	                                    {html_options options=$cachingTimeOptions name="settings[cache_time_article]" selected=$config.cache_time_article class="form-control form-control-sm select" data-width="1%"}
	                                    {html_options options=$cachingPeriodOptions name="settings[cache_period_article]" selected=$config.cache_period_article class="form-control form-control-sm select" data-width="1%"}
									</div>
								</div>
							</div>

							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:caching:rss}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:caching:rssText}</span>
								</label>
								<div class="col-lg-3">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" id="cache_enabled_rss" name="settings[cache_enabled_rss]" value="1" {if $config.cache_enabled_rss}checked{/if}>
										<label class="form-check-label" for="cache_enabled_rss">{general:enableCachingFor}</label>
									</div>
								</div>
								<div class="col-md-3 col-xs-2">
									<div class="input-group">
										{html_options options=$cachingTimeOptions name="settings[cache_time_rss]" selected=$config.cache_time_rss class="form-control form-control-sm select" data-width="1%"}
										{html_options options=$cachingPeriodOptions name="settings[cache_period_rss]" selected=$config.cache_period_rss class="form-control form-control-sm select" data-width="1%"}
									</div>
								</div>
							</div>

							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:caching:sitemap}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:caching:sitemapText}</span>
								</label>
								<div class="col-lg-3">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" id="cache_enabled_sitemap" name="settings[cache_enabled_sitemap]" value="1" {if $config.cache_enabled_sitemap}checked{/if}>
										<label class="form-check-label" for="cache_enabled_sitemap">{general:enableCachingFor}</label>
									</div>
								</div>
								<div class="col-md-3 col-xs-2">
									<div class="input-group">
                                    {html_options options=$cachingTimeOptions  name="settings[cache_time_sitemap]" selected=$config.cache_time_sitemap|default:'' class="form-control form-control-sm select" data-width="1%"}
                                    {html_options options=$cachingPeriodOptions name="settings[cache_period_sitemap]" selected=$config.cache_period_sitemap|default:'' class="form-control form-control-sm select" data-width="1%"}
									</div>
								</div>
							</div>

							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:caching:clearCache}<br />
									<span class="p-0 font-size-sm font-italic text-muted">Данная опция позволяет очистить кеш шаблонов.</span>
								</label>
								<div class="col-lg-6">
									<a href="javascript:void('');" class="btn btn-sm btn-primary control-cache" id="status" onclick="clearCache()">{settings:caching:clearCacheAction}</a>
								</div>
							</div>


						</fieldset>
					</div>

					<div class="tab-pane fade" id="statistic">
						<fieldset class="mb-3">
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:statistics:yandex}</label>
								<div class="col-lg-6"><input class="form-control" type="text" name="settings[yandex_metrika]" value="{$config.yandex_metrika}"></div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:statistics:google}</label>
								<div class="col-lg-6"><input class="form-control" type="text" name="settings[google_analytics]" value="{$config.google_analytics}"> </div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:statistics:enable}</label>
								<div class="col-lg-6">
									<div class="form-check form-switch mb-2">
										<input type="checkbox" class="form-check-input" name="settings[statistics_enabled]" value="1" {if $config.statistics_enabled}checked{/if}>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:statistics:bot}</label>
								<div class="col-lg-6"><textarea name="settings[bot_id_strings]" class="form-control" rows="5">{$config.bot_id_strings}</textarea></div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:statistics:query}</label>
								<div class="col-lg-6"><textarea name="settings[query_fields_strings]" class="form-control" rows="5">{$config.query_fields_strings}</textarea></div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:statistics:deleteStats}</label>
								<div class="col-lg-6">
									<div class="input-group">
										<button type="button" class="btn btn-success"><i class="icon-calendar3"></i></button>
										<input type="text" class="form-control daterange-stats" name="date" value="{$deleteStatsTime|date_format:"%Y-%m-%d"}" readonly>
										<button class="btn btn-sm btn-primary" type="button" onclick="deleteStats();">{general:delete}</button>
									</div>
								</div>
							</div>
						</fieldset>
					</div>

{*					<div class="tab-pane fade" id="update_url">
						<fieldset class="mb-3">
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:updateUrls:oldDomen}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:updateUrls:oldDomenText}</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="text" name="settings[old_site_url]" value="" placeholder="http://domain.uz/">
								</div>
							</div>
							<div class="row mb-3">
								<label class="col-form-label col-lg-6">{settings:updateUrls:newDomen}<br />
									<span class="p-0 font-size-sm font-italic text-muted">{settings:updateUrls:newDomenText}</span>
								</label>
								<div class="col-lg-6">
									<input class="form-control" type="text" name="settings[site_url]" value="{$config.site_url}" placeholder="http://domain.uz/">
								</div>
							</div>
						</fieldset>
					</div>
*}


				</div>
			</div>
		</div>


		<div class="col-md-12 main main_buttons text-center">
			{$smarty.capture.buttons nofilter}
		</div>

	</div>


</form>

{if isset($messages.saved)}<span id="savedMessage" onclick="new Noty({ text: '{settings:messages:0}', type: 'success' }).show();"></span>{/if}
{if isset($errors.htaccess)}<span id="htaccessError" onclick="new Noty({ text: '{settings:errors:0}', type: 'error' }).show();"></span>{/if}
{if isset($errors.serializations)}<span id="serializationsError" onclick="new Noty({ text: '{settings:errors:1}', type: 'error' }).show();"></span>{/if}

<script>
    $(document).ready(function() {
        {if isset($errors.htaccess)}$('#htaccessError').click(); {/if}
        {if isset($errors.serializations)}$('#serializationsError').click(); {/if}
        {if isset($messages.saved)}$('#savedMessage').click(); {/if}

    });
    function deleteStatsMessage() { new Noty({  text: '{settings:statistics:statsDeleted}', type: 'success'}).show(); }
    function clearCacheMessage() { new Noty({ text: '{settings:caching:clearedCache}', type: 'success'}).show(); }


    $(document).on('click', 'input[name=date_custom]', function () {
        const radioChecked = document.querySelector('input[name="date_custom"]:checked');
        const radioDataValue = radioChecked.getAttribute('data-value')
        console.log(radioDataValue)

        $('.date_format_custom').val(radioChecked.value);
        $('.date_format_custom_real').text(radioDataValue);
    })

    $(document).on('click', '.fn_test_smtp', function() {

        const fn_test_smtp_status = $('.fn_test_smtp_status');
        const fn_test_smtp_trace = $('.fn_test_smtp_trace');

        fn_test_smtp_status.removeClass('show');

        var server = $('input[name="settings[smtp_server]"]').val(),
            port   = $('select[name="settings[smtp_port]"]').val(),
            user   = $('input[name="settings[smtp_user]"]').val(),
            pass   = $('input[name="settings[smtp_pass]"]').val();

        $.post('{$adminUrl}/settings?action=test_smtp', { "settings[smtp_server]": server, "settings[smtp_port]": port, "settings[smtp_user]": user, "settings[smtp_pass]": pass }, function (response) {
	        fn_test_smtp_status.text(response.message);
            fn_test_smtp_status.addClass('show');
	        if (response.status === true) {
		        fn_test_smtp_trace.text('').closest('.fn_row').addClass('hidden');
		        fn_test_smtp_status.removeClass('text-danger').addClass('text-success');
                setTimeout(() => {
                    fn_test_smtp_status.removeClass('show');
                }, 5000);
	        } else {
		        fn_test_smtp_trace.html(response.trace).closest('.fn_row').removeClass('hidden');
		        fn_test_smtp_status.removeClass('text-success').addClass('text-danger');

	        }


        });
    })

</script>

