<?php

namespace Mnv\Models;

use Mnv\Core\Config;
use Mnv\Core\Model;
use Mnv\Core\Uploads\ImageSizes;
use Mnv\Http\Request;

/**
 * Class Jobs
 *
 * @package Mnv\Models\Contents
 */
class Jobs extends Model
{

    /** @var string */
    protected string $table = 'jobs';

    /** @var string */
    protected string $table_description = 'jobs_description';

//    protected string $columns = 'jobId, sectionId, status, fileName, publishedOn, isFeatured, orderBy, lang_code, title, alias, telegram, link, links, project, content, url';
//    protected string $columns = '*';
//    protected string $columns = 'j.jobId, j.sectionId, j.userId, j.status, j.fileName AS filename, j.publishedOn, j.isFeatured, j.orderBy, j.url, j.brand,j.inn, j.fullName,j.phone, j.email, j.consumer, j.expert, j.payment, ji.fileId, ji.imageId, f.directory, f.path, f.fileName, f.size';
    protected string $columns = 'j.jobId, j.sectionId, j.userId, j.status, j.fileName AS filename, j.publishedOn, j.isFeatured, j.orderBy, j.url, j.brand, j.inn, j.fullName,j.phone, j.email, j.consumer, j.expert, j.payment, j.bot';

    /** @var string */
    protected string $table_image = 'job_images';
    protected string $table_file = 'files AS f';

    /** @var string */
    protected string $primaryKey = 'jobId';

    /** @var string */
    protected string $orderBy = 'publishedOn DESC';

    /** @var array|mixed */
    public $blockIds = [];
    public $description = [];
    public $pdf_lang;

    public $paramIsFeatured = [
        0 => 'Нет',
        1 => 'Да'
    ];

    public $bots = [
        'Y' => 'Да',
        'N' => 'Нет',
    ];
    public function __construct(Request $request)
    {
        $this->id = $request->get('id');
        $this->data = $request->get('job', '');
        $this->description = $request->get('description', '');
        $this->pdf_lang = $request->get('pdf_lang', '');
        $this->blockIds = $request->get('ids', '');
    }

    public function edit(): Model
    {
        if (!empty($this->id)) {
            $this->data = connect($this->table.' AS j')->select($this->columns)->where('j.jobId', $this->id)->get('array');
//            print_r($this->data);
//            print_r(connect()->getQuery());
            if (!empty($this->data)) {
                $this->data['description'] = connect($this->table_description)->where($this->primaryKey, $this->id)->indexKey('lang_code')->getAllIndexes('array');
            }
//            if (!empty($this->data)) {
//               $this->getPdfFiles();
//            }
        }

//        print_r($this->data);

        return $this;
    }


    /** Получить все из таблицы images модели  */
    public function getPdfFiles()
    {
        $docs = [];
        if ($images = connect($this->table_image)->where($this->primaryKey, $this->id)->where('type', 'docs')->indexKey('lang_code')->getAllIndexes('array')) {
            collect($images)->map(function ($item) use (&$docs) {
                if ($file = $this->getFileInfo($item['fileId'])) {
                    $this->data['pdf'][$item['lang_code']] = ImageSizes::init()->get($item, $file);
                }
            })->toArray();
        }


    }


    /** Фильтрация / сортировка */
    private function sorting(): void
    {
        global $SECTIONS;

        if (!empty($this->filter['query'])) {
            connect()->grouped(function ($q) {
                $q->like('brand', "%".$this->filter['query']."%");
//                $q->like('title', "%" . $this->filter['query'] . "%")->orLike('content', "%" . $this->filter['query']. "%");
            });
        }
        if (!empty($this->filter['status'])) {
            connect()->where('status', $this->filter['status']);
        }

        if (!empty($this->filter['section'])
            && !empty($SECTIONS[$this->filter['section']])
        ) {
            $sectionIds = array($this->filter['section']);
            if (!empty($SECTIONS[$this->filter['section']]['allChildren'])) {
                $sectionIds = array_merge(
                    $sectionIds,
                    $SECTIONS[$this->filter['section']]['allChildren']
                );
            }

            connect()->in('sectionId', $sectionIds);
        }
    }

    /** Получение всех */
    public function all($limit, $page)
    {
        /** Фильтрация / сортировка */
        $this->sorting();
        $this->result = connect($this->table)->usingJoin($this->table_description, $this->primaryKey)->select('*')->where('lang_code', Config::getValue('website_language'))->orderBy($this->orderBy)->pagination($limit, $page)->getAll('array');
        $this->result = prepareJobs($this->result, false);
//        print_r($this->result);

    }

    /** Получение кол-во */
    public function total(): void
    {
        /** Фильтрация / сортировка */
        $this->sorting();

        $this->total = (int)connect($this->table)->usingJoin($this->table_description, $this->primaryKey)->count('*', 'count')->where('lang_code', Config::getValue('website_language'))->getValue();
//        print_r(connect()->getQuery().PHP_EOL);
    }

    public function remove(): bool
    {
        if (!empty($this->id)) {
            if (connect($this->table)->where($this->primaryKey, $this->id)->delete()) {
                connect($this->table_description)->where($this->primaryKey, $this->id)->delete();
                connect($this->table_image)->where($this->primaryKey, $this->id)->delete();

                return true;
            }
        }
        return false;
    }

    /** Получить ID последней работы + 1 */
    public function getMaxId()
    {
        $ID = $this->getMaxValue('jobId');
        return !empty($ID) ? $ID + 1 : 1;
    }

    /**
     * Проверка на совпадение и получение fileName
     *
     * @param  string|null  $fileName
     */
    public function checkFileName(?string $fileName)
    {
        if (empty($fileName)) {
            $maxId = $this->getMaxValue($this->primaryKey);
            return $maxId ? $maxId + 1 : 1;
        }

        if (!empty($this->id)) {
            connect()->where($this->primaryKey, '<>', $this->id);
        }
        if ($fileName = connect($this->table)->select('fileName')->where('LOWER(fileName)', strtolower($fileName))->getValue()) {
            return $fileName;
        }

        return null;
    }

    public function prepare(array $data, int $managerId, array $languages): bool
    {
        $data['modifiedBy'] = $managerId;
        $data['modifiedOn'] = gmdate('Y-m-d H:i:s');
        $data['publishedOn'] = adjustTime(date('Y-m-d H:i:s', strtotime($data['publishedOn'])), true);

        if (empty($this->id)) {
            $data['addedBy'] = $managerId;
            $data['addedOn'] = gmdate('Y-m-d H:i:s');
            $data['orderBy'] = $this->getMaxValue('orderBy') + 1;

            if ($this->id = $this->insert($data)) {
                foreach ($languages as $language) {
                    $this->insetDescription($language['codename']);
                }
                return true;
            }
        } else {
            if ($this->update($data)) {
                foreach ($languages as $language) {
                    $this->updateDescription($language['codename']);
                }
                return true;
            }
        }

        return false;
    }

    /** Добавление описания к работе */
    public function insetDescription($language)
    {
        $description = $this->description[$language];
        $description['lang_code'] = $language;
        $description['jobId'] = $this->id;
        $description['youtube'] = $this->parseYoutubeLink(
            $description['youtube']
        );

        connect($this->table_description)->insert($description);
    }

    /** Обновление описания у работы */
    public function updateDescription($language)
    {
        $description = $this->description[$language];
        $description['youtube'] = $this->parseYoutubeLink(
            $description['youtube']
        );

//        print_r($description);
        connect($this->table_description)->where($this->primaryKey, $this->id)
            ->where("lang_code", $language)->update($description);
    }


    private function parseYoutubeLink($youtube)
    {
        if (!empty($youtube)) {
            if (preg_match(
                '/(?:https?:)?(?:\/\/)?(?:[0-9A-Z-]+\.)?(?:youtu\.be\/|youtube(?:-nocookie)?\.com\/\S*?[^\w\s-])((?!videoseries)[\w-]{11})(?=[^\w-]|$)(?![?=&+%\w.-]*(?:[\'"][^<>]*>|<\/a>))[?=&+%\w.-]*/i',
                $youtube
            )
            ) {
                $youtube = preg_replace(
                    '/(?:https?:)?(?:\/\/)?(?:[0-9A-Z-]+\.)?(?:youtu\.be\/|youtube(?:-nocookie)?\.com\/\S*?[^\w\s-])((?!videoseries)[\w-]{11})(?=[^\w-]|$)(?![?=&+%\w.-]*(?:[\'"][^<>]*>|<\/a>))[?=&+%\w.-]*/i',
                    '$1',
                    $youtube
                );
                $youtube = "https://www.youtube.com/embed/".$youtube;
            } elseif (preg_match(
                '/https:\/\/(?:www.)?vimeo.com\/([0-9]{9})(?:\#t=(\d+)s)?/i',
                $youtube
            )
            ) {
                $youtube = preg_replace(
                    '/https:\/\/(?:www.)?vimeo.com\/([0-9]{9})(?:\#t=(\d+)s)?/i',
                    '$1',
                    $youtube
                );
                $youtube = "https://player.vimeo.com/video/".$youtube
                    ."?title=0&byline=0&portrait=0";
            } else {
                $youtube = '';
            }
        }

        return $youtube;
    }

    public function getDescription($jobId, $language)
    {
        return connect($this->table_description)->where($this->primaryKey, $jobId)->where('lang_code', $language)->get('array');
    }


    /**
     * Загрузка картинок в галерею или добавление документов
     *
     * @param  int  $modelId
     * @param  array  $images
     *
     * @return bool
     */
    public function addPdf(int $modelId, array $images): bool
    {
        $idx = 0;
        if ($order = connect($this->table_image)->where(
            $this->primaryKey,
            $modelId
        )->where('type', 'docs')->max('orderBy')->getValue()
        ) {
            $idx = $order;
        }

        foreach ($images['docs'] as $image) {
            $idx++;
            $imageUpload = [
                $this->primaryKey => $modelId,
                'lang_code' => $image['pdf_lang'],
                'fileId' => $image['fileId'],
                'type' => 'docs',
                'position' => 'default',
                'orderBy' => $idx
            ];

            connect($this->table_image)->replace($imageUpload);
        }

        return true;
    }


}