<?php


namespace Mnv\Modules;

use Mnv\Core\Locale\I18N;

/**
 * Class OnlineReception
 * @package Mnv\Modules
 */
class OnlineReception
{
    /** @var string */
    protected string $table = 'online_reception';
    /** @var string  */
    protected string $primaryKey = 'id';

    protected string $orderBy = 'id DESC';

    public $response = [];

    public $statuses = [
        'reviewed'   => 'Рассмотрено',
        'processing' => 'В обработке',
        'refused'    => 'Отказано',
    ];

    public function __construct($sectionId, $color)
    {
        $this->statuses = array(
            'all'        => I18N::locale("Всего обращений", "Жами сўровлар", "Total messages", "Barcha murojaatlar"),
            'reviewed'   => I18N::locale("Рассмотрено", "Кўриб чиқилди", "Reviewed", "Ko'rib chiqildi"),
            'processing' => I18N::locale("В обработке", "Қайта ишлашда", "Processing", "Qayta ishlashda"),
            'refused'    => I18N::locale("Отказано", "Рад етилди", "Refused", "Rad etilgan"),
        );

        $section = connect('sections')->select('sectionId, name')->where('sectionId', $sectionId)->get('array');

        $this->response['id'] = $section['sectionId'];
        $this->response['name'] = $section['name'];
        $this->response['data']['color'] = $color;
    }

    public function stats()
    {
        $count = 0;
        $results = connect()->table($this->table)->select('status')->count('status', 'count')->groupBy('status')->getAll('array');
        if (!empty($results)) {

            foreach ($results as $result) {
                $count += $result['count'];
                $this->response['data']['x_data'][] = $this->statuses[$result['status']];
                $this->response['data']['y_data'][] = $result['count'];

            }
            $this->response['data']['x_data'][] = $this->statuses['all'];
            $this->response['data']['y_data'][] = $count;
        }

    }
}
