<?php

namespace Mnv\Modules\Participants;

use Mnv\Core\Feedback;
use Mnv\Core\Locale\I18N;
use Mnv\Core\Utilities\Cookie\Session;
use PHPMailer\PHPMailer\PHPMailer;

/**
 * Class SiteUsers
 * @package Mnv\Modules\Participants
 */
class SiteUsers
{

    /** @var string */
    private string $table = 'customers';

    /** @var string  */
    private string $primaryKey = 'userId';


    public $siteHomeUrl = SITE_URL;
    public $siteUserAccountUrl = SITE_URL.'/account/';

    /**
     * @var
     */
    public  $errors;
    private $config;
    private $smarty;
    private $sign_out;
    private $mail;

    protected $current_date;
    protected $expiration_time;


    /**
     * @var
     */
    private $userData;
    private $newUserData;

    /**
     * @var array
     */
    private $requiredFields = array( 'firstName', 'lastName', 'email');


    public function __construct()
    {
        global $config, $smarty;

        $this->config = $config;
        $this->smarty = $smarty;
        $this->sign_out=  SITE_URL. '/';


        $this->mail = new PHPMailer();

        $this->mail->SMTPAuth = true;
        $this->mail->isSMTP();
        $this->mail->SMTPDebug = 0;
        $this->mail->CharSet    = $this->config['charset'];
        $this->mail->Host       = $this->config['smtp_server'];
        $this->mail->Username   = $this->config['smtp_user'];
        $this->mail->Password   = $this->config['smtp_pass'];
        $this->mail->SMTPSecure = $this->config['smtp_secure'];
        $this->mail->Port       = $this->config['smtp_port'];


        $this->current_date = date("Y-m-d H:i:s", time());
        // Установить срок действия куки на 1 месяц
        $this->expiration_time = time() + 31536000;
    }

    /**
     * Добавление нового пользователя
     *
     * @param $userData
     * @param bool $activate
     * @return bool
     * @throws SiteUserException
     * @throws SmartyException
     */
    public function addNewUser($userData, $activate = true)
    {
        $this->checkRequiredFiedls($userData);
        if (empty($this->errors)) {
            $new_password               = $this->generateActivationCode(5);
            $userData['password']       = md5($new_password);
            $userData['ip']             = $_SERVER['REMOTE_ADDR'];
            $userData['registeredOn']   = date('Y-m-d');
            $userData['status']         = 'active';

//            print_r($userData);

            if ($userData['userId'] = connect($this->table)->insert($userData)) {
                $this->newUserData  = &$userData;
                if ($this->sendNewUserPasswordCode($userData, $new_password)) {
                    return true;
                } else {
                    return false;
                }
            } else {
                $this->error(
                    0,
                    I18N::locale(
                        "Ошибка регистрации, повторите еще раз.",
                        "Ro'yxatdan o'tish xatosi, qaytadan urining.",
                        "Registration error, please try again."
                    )
                );
            }
        } else {
            $this->error( 0,
                I18N::locale(
                    "Поля (Имя, Email, телефон, пароль) не должны быть пустыми!",
                    "Maydonlar (ism, elektron pochta, telefon, parol) bo'sh bo'lmasligi kerak!",
                    "The fields (Name, Email, phone, password) must not be empty!"
                )
            );
        }
    }


    /**
     * Изменения данных пользователя
     *
     * @param $userData
     * @param $userId
     * @return bool
     * @throws SiteUserException
     */
    public function changeUserData($userData, $userId)
    {
        $this->requiredFields = array('userName', 'phone', 'email');

        $this->checkRequiredFiedls($userData);

        if (empty($this->errors)) {


            if ($oldUserInfo = connect($this->table)->where($this->primaryKey, $userId)->get('array')) {

                $userData['status'] = $oldUserInfo['status'];
                $userData['userId'] = $oldUserInfo['userId'];

                if ( connect($this->table)->where($this->primaryKey, $userId)->update($userData)) {
                    return true;
                } else {
                    $this->error(0, I18N::locale(
                        "Вы не вносили никаких изменений!",
                        "Siz hech qanday o'zgartirish kiritmadingiz!",
                        "You haven't made any changes!"
                    ));
                }
            } else {
                $this->error(0, I18N::locale(
                    "Нет такого пользователя...",
                    "Bunday foydalanuvchi yo'q...",
                    "No such user..."
                ));
            }
        } else {
            $this->error(0, I18N::locale(
                "Поля имя, email, номер телефона обязательны для заполнения",
                "Maydonlar nomi, elektron pochta manzili, telefon raqami ko'rsatilishi shart",
                "Fields name, email, phone number are required"
            ));
        }
    }

    /**
     * Изменение пароля пользователя
     *
     * @param $userPwd
     * @param $userId
     * @return bool
     * @throws SiteUserException
     */
    public function changeUserPwd($userPwd, $userId)
    {
        if (!empty($userPwd['pwdnew'])) {

            if ($pwdOldUser = connect($this->table)->select('password')->where($this->primaryKey, $userId)->getValue()) {
                if ($pwdOldUser != md5($userPwd['pwdold'])) {
                    $this->error( 0, I18N::locale(
                        "Старый пароль неверный.",
                        "'Eski parol noto'g'ri.'",
                        "The old password is incorrect."
                    ));
                    return false;
                } else {
                    connect($this->table)->where($this->primaryKey, $userId)->update(['password' => md5($userPwd['pwdnew'])]);
                    return true;
                }
            } else {
                $this->error( 0, I18N::locale(
                    "Не известная ошибка!",
                    "Noma'lum xato!",
                    "Unknown error!"
                ));
            }
        } else {
            $this->error( 0, I18N::locale(
                "Поля пароли не должны быть пустыми!",
                "Parol maydonlari bo'sh bo'lmasligi kerak!",
                "Password fields must not be empty!"
            ));
        }
    }


    /**
     * Проверить существует ли пользователь с таким `login`
     *
     * @param $login
     * @return bool
     */
    public function checkUserLogin($login)
    {
        if (connect($this->table)->select('login')->where('login', $login)->getValue()) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * Проверить существует ли пользователь с таким `email` адресом
     *
     * @param $email
     * @return bool
     * @throws SiteUserException
     */
    public function checkUserEmail($email)
    {
        if ($emailUser = connect($this->table)->select('email')->where('email', $email)->getValue()) {
            $this->error( 0, I18N::locale(
                "Этот " . $emailUser . " адрес электронной почты уже существует!",
                "Bu ". $emailUser . " elektron pochta manzili allaqachon mavjud!",
                "This " . $emailUser. " email address already exists!"
            ));
        } else {
            return true;
        }
    }

    /**
     * Восстановление пароля, проверка существует ли пользователь с таким `email` адресом
     *
     * @param $email
     * @return bool
     * @throws SiteUserException
     */
    public function recoveryUserEmail($email)
    {
        if ($userEmail = connect($this->table)->select('email')->where('email', $email)->getValue()) {
            return $userEmail;
        } else {
            $this->error( 0, I18N::locale(
                "Нет " . $email . " адрес электронной почты уже существует!",
                "Bu ". $email . " elektron pochta manzili allaqachon mavjud!",
                "This " . $email. " email address already exists!"
            ));
        }
    }


    /**
     * Проверить существует ли пользователь с таким номером телефона `phone`
     * @param $phone
     * @return bool
     * @throws SiteUserException
     */
    public function checkUserPhone($phone)
    {
        $phone = preg_replace('/[^0-9]/', '', $phone);
        $pregPhone = preg_replace('/([0-9]{3})([0-9]{2})([0-9]{3})([0-9]{2})([0-9]{2})/', '+$1 ($2) $3-$4-$5', $phone);
        if ($phoneUser = connect($this->table)->select('phone')->where('phone', $pregPhone)->getValue()) {
            $this->error( 0, I18N::locale(
                "C " . $phoneUser . " таким номером телефона пользователь уже существует!",
                "Bilan " . $phoneUser. " foydalanuvchi bu telefon raqami bilan allaqachon mavjud!",
                "With " . $phoneUser. " the user already exists with this phone number!"
            ));
        } else {
            return true;
        }
    }

    /**
     * Изменение статуса при подтверждение `email` адреса
     *
     * @param $userId
     * @param $newStatus
     * @param string $code
     * @return bool
     */
    public function changeUserStatus($userId, $newStatus, $code = '')
    {
        if (!empty($code)) {
            connect()->where('activationCode', $code);
        }

        $value['status'] = $newStatus;
        if (connect($this->table)->select('phone')->where('userId', $userId)->update($value)) {
            $userData = connect($this->table)->where('userId', $userId)->get('array');
            if ($userData) {
                $this->authMe($userData);
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    /**
     * Проверка данных `login` и `password` при входе в личный кабинет пользователя
     *
     * @param $login
     * @param $password
     * @return bool
     * @throws SiteUserException
     */
    public function signInEmail($email, $password)
    {

        if ($userData = connect($this->table)->where('login', $email)->orWhere('email', $email)->where('password', md5($password))->get('array')) {
            if ($userData['status'] === 'waiting') {
                $this->error( 0, I18N::locale(
                    "Ваш аккаунт не активирован",
                    "Sizning hisobingiz faollashtirilmagan",
                    "Your account is not activated"
                ));
            } elseif ($userData['status'] === 'blocked') {
                $this->error( 0, I18N::locale(
                    "Ваш аккаунт заблокирован, свяжитесь с администрацией сайта",
                    "Sizning hisobingiz bloklangan, sayt ma'muriyatiga murojaat qiling",
                    "Your account is blocked, contact the site administration"
                ));
            } else {
                $this->authMe($userData);
                return true;
            }
        } else {

            $this->error( 0, I18N::locale(
                "Не верные логин или пароль",
                "Noto'g'ri login yoki parol",
                "Incorrect login or password"
            ));
        }
    }

    /**
     * Проверка данных `login` и `password` при входе в личный кабинет пользователя
     *
     * @param $login
     * @param $password
     * @return bool
     * @throws SiteUserException
     */
    public function checkLogin($login, $password)
    {
        if ($this->validateEmail($login) === true) {
            connect()->where('email', $login);
        } elseif ($this->validatePhoneNumber($login) === true) {
            $login =  preg_replace('/[^0-9]/', '', $login);
            $login = preg_replace('/([0-9]{3})([0-9]{2})([0-9]{3})([0-9]{2})([0-9]{2})/', '+$1 ($2) $3-$4-$5', $login);

            connect()->where('phone', $login);
        }

//        print_r($where);
        if ($userData = connect($this->table)->where('password', md5($password))->get('array')) {
            if ($userData['status'] === 'waiting') {
                $this->error( 0, I18N::locale(
                    "Ваш аккаунт не активирован",
                    "Sizning hisobingiz faollashtirilmagan",
                    "Your account is not activated"
                ));
                return false;
            } elseif ($userData['status'] === 'blocked') {
                $this->error( 0, I18N::locale(
                    "Ваш аккаунт заблокирован, свяжитесь с администрацией сайта",
                    "Sizning hisobingiz bloklangan, sayt ma'muriyatiga murojaat qiling",
                    "Your account is blocked, contact the site administration"
                ));
                return false;
            } else {
                $this->authMe($userData);
                return true;
            }
        } else {
            $this->error( 0, I18N::locale("Не верный пароль", "Noto'g'ri login yoki parol", "Incorrect login or password"));
            return false;
        }
    }

    /**
     * Проверка данных `login` и `password` при входе в личный кабинет пользователя
     *
     * @param $email
     * @return bool
     * @throws SiteUserException
     */
    public function recoveryEmailPassword($email)
    {
        if ($userData = connect($this->table)->where('email', $email)->get('array')) {

            $new_password = $this->generateActivationCode(5);

            connect($this->table)->where('email', $email)->update(['password' => md5($new_password)]);

            if ($this->sendNewUserPasswordCode($userData, $new_password)) {
                return true;
            } else {
                return false;
            }
        } else {
            $this->error( 0, I18N::locale("Нет такого участника", "Noto'g'ri login yoki parol", "Incorrect login or password"));
            return false;
        }
    }
    /**
     * Авторизация пользователя / Отправка SMS.
     *
     * @param $request
     * @return array
     * @throws Exception
     */
    public function checkPhone($request)
    {
        $request['phone'] =  preg_replace('/[^0-9]/', '', $request['phone']);
        $request['phone'] = preg_replace('/([0-9]{3})([0-9]{2})([0-9]{3})([0-9]{2})([0-9]{2})/', '+$1 ($2) $3-$4-$5', $request['phone']);

        if ($this->checkPassword($request['phone'], $request['password'])) {
            if ($response['status'] === 200) {
                $userUpdate['smsCode']      = $response['smsCode'];
                $userUpdate['smsActive']    = 0;

                connect($this->table)->where('phone', $request['phone'])->update($userUpdate);

                Session::set('userPhone', $request['phone']);
                return array('code' => 1, 'status' => 200, 'active' => 'phone', 'message' => I18N::locale("Вам телефон отправлен код подтверждения!", "Вам телефон отправлен код подтверждения!", "Вам телефон отправлен код подтверждения!"));
            }
        } else {
            return array('code' => 0, 'status' => 403, 'message' => I18N::locale("Неправильный пароль!", "'Parol noto'g'ri!'", "Wrong password!"));
        }
    }

    /**
     * Проверка паролей на достоверность
     *
     * @param $password
     * @param $password2
     * @throws SiteUserException
     */
    private function checkUserPassword($password, $password2)
    {
        if ($password != $password2) {
            $this->error( 0, I18N::locale(
                "Данные поля Пароль и Подтверждение пароля различаются!",
                "Parol va parolni tasdiqlash uchun bu maydonlar boshqacha!",
                "These fields for Password and Confirm Password are different!"
            ));
        }
    }



    /** Отправка писем на почту пользователя  */



    /**
     * Отправка нового кода на `email` адрес для подтвержения пароля
     *
     * @param $email
     * @return bool
     * @throws SmartyException
     * @throws \Mailer\PHPMailer\Exception
     */
    public function sendPasswordChangeCode($email)
    {
        connect($this->table)->where('email', $email)->update(['activationCode' => $this->generateActivationCode(8)]);

        dbQuery('customers', DB_UPDATE, array('where' => "email='$email'", 'values' => "activationCode = '". $this->generateActivationCode(8). "'"));

        $userData = connect($this->table)->where('email', $email)->where('status', 'active')->get('array');

        $this->mail->setFrom($this->config['smtp_user'], $this->config['website_name']);
        $this->mail->addAddress($userData['email']);
        $this->mail->isHTML(true);
        $this->mail->Subject = 'Сменить пароль';
        $this->smarty->assign('userData', $userData);
        $this->mail->Body = $this->smarty->fetch('mail/recovery-confirm.tpl');

        if (!$this->mail->send()) {
            $this->errors = $this->mail->ErrorInfo;
            return false;
        } else {
            return true;
        }
    }

    /**
     * Отправка нового пароля пользователю на `email` адрес
     *
     * @param $userId
     * @param $code
     * @return bool
     * @throws \SmartyException
     */
    public function sendNewPassword($userId, $code)
    {
        $where[] = "userId = '$userId'";
        $where[] = "activationCode = '$code'";

        if ($userData = connect($this->table)->where('userId', $userId)->where('activationCode', $code)->get('array')) {
            $new_password = $this->generateActivationCode(5);

            connect($this->table)->where($this->primaryKey, $userId)->update(['password' => md5($new_password), 'activationCode' => $this->generateActivationCode(8),]);

            $userData['password'] = $new_password;
//            $this->smarty->assign('userData', $userData);
            $recipient = $userData['email'];

            $this->mail->setFrom($this->config['smtp_user'], $this->config['website_name']);
            $this->mail->addAddress($recipient);
            $this->mail->Subject = 'Ваш новый пароль';
            $this->mail->isHTML(true);
            $this->smarty->assign('userData', $userData);
            $this->mail->Body = $this->smarty->fetch('mail/recovery-complete.tpl');

            if (!$this->mail->send()) {
                $this->errors = $this->mail->ErrorInfo;
                return false;
            } else {
                return true;
            }
        } else {
            return false;
        }
    }

    /**
     * Отправка на почту данных для подтверждение регистрации
     *
     * @param $userData
     * @return bool
     * @throws \SmartyException
//     * @throws \Mailer\PHPMailer\Exception
     */
    private function sendNewUserPasswordCode($userData, $new_password)
    {

        $feedbackClass = new Feedback();


//        $recipient = $userData['email'];
        $userData['password'] = $new_password;
        $this->smarty->assign('userData', $userData);

//        $this->mail->setFrom($this->config['smtp_user'], $this->config['website_name']);
//        $this->mail->addAddress($recipient);
//
//        $this->mail->isHTML(true);
//        $this->mail->Subject = 'Ваш пароль для входа на сайт '. $this->config['website_name'];

//        $this->smarty->assign($userData);
        $this->mail->Body = $this->smarty->fetch('mail/new-user-password-code.tpl');

        $subject = 'Ваш пароль для входа на сайт '. $this->config['website_name'];
        $htmlBody = $this->smarty->fetch('mail/new-user-password-code.tpl');

        if (!$feedbackClass->send($userData['email'], $userData['firstName'] . ' ' . $userData['lastName'], $subject, $htmlBody)) {
            return false;
        } else {
            return true;
        }

//        if (!$this->mail->send()) {
//            $this->errors = $this->mail->ErrorInfo;
//            return false;
//        } else {
//            return true;
//        }
    }

    /**
     * Отправка на почту данных для подтверждение регистрации
     *
     * @param $userData
     * @return bool
     * @throws SmartyException
     * @throws \Mailer\PHPMailer\Exception
     */
    private function sendActivationCode($userData, $new_password)
    {
        $recipient = $userData['email'];
        $userData['password'] = $new_password;
        $this->smarty->assign('userData', $userData);

        $this->mail->setFrom($this->config['smtp_user'], $this->config['website_name']);
        $this->mail->addAddress($recipient);

        $this->mail->isHTML(true);
        $this->mail->Subject = 'Подтверждение регистрации';
        $this->smarty->assign($userData);
        $this->mail->Body = $this->smarty->fetch('mail/recovery-complete.tpl');

        if (!$this->mail->send()) {
            $this->errors = $this->mail->ErrorInfo;
            return false;
        } else {
            return true;
        }
    }

    /**
     * Валидация `email` адреса
     *
     * @param $email
     * @return bool
     */
    public function validateEmail($email)
    {
        if (preg_match('/^[A-Z0-9\._\-]+@[A-Z0-9\.\-]+\.[A-Z]{2,4}$/i', $email)) {
            if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
                return true;
            } else {
                return false;
            }
        }  else {
            return false;
        }
    }

    /**
     * Валидация номера телефона регион Узбекистан
     *
     * @param $phone
     * @return bool
     */
    public function validatePhoneNumber($phone)
    {
        $phone =  preg_replace('/[^0-9]/', '', $phone);
        // Разрешить +, - и. в номере телефона
        $filtered_phone_number = filter_var($phone, FILTER_SANITIZE_NUMBER_INT);
        // Проверить длину номера
        if (strlen($filtered_phone_number) === 12) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Проверка полей на пустоту
     *
     * @param $userData
     * @return bool
     */
    private function checkRequiredFiedls($userData)
    {
        foreach ($this->requiredFields as $requiredField) {
            if (empty($userData[$requiredField])) {
                $this->errors[$requiredField] = 'empty';
                $errors = true;
            }
        }

        if (empty($errors)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Переадресация на главную страницу
     */
    public function refuseMe()
    {
        Session::delete('siteUser');

        $str = $_SERVER['REDIRECT_URL'];
        $tmp = explode('/',$str);
        if ($tmp[1]=='uz') {
            $sub='/'.$tmp[1].'/';
        } else {
            $sub='/';
        }
        header('location: '.$sub);
    }

    /**
     * Перенаправление на главную страницу при успешной авторизации
     *
     * @param $userData
     */
    private function authMe($userData)
    {
        Session::set('siteUser', $userData);

//        $str = $_SERVER['REDIRECT_URL'];
//        $tmp = explode('/',$str);
//        if ($tmp[1] == 'uz') {
//            $sub = '/'.$tmp[1].'/';
//        } else {
//            $sub = '/';
//        }
//         header('location: ' . SITE_URL);
    }


    /**
     * Создает исключение SiteUserException с заданными параметрами.
     *
     * @param int $code error code.
     * @param string|array $message error message.
     * @param string $data parameter name, that resulted to this error.
     * @throws SiteUserException
     */
    public function error($code, $message = null, $data = null)
    {
        throw new SiteUserException($code, $message, $data);
    }

    /**

    /**
     * Генерация кода
     *
     * @param int $length
     * @param string $userName
     * @return bool|string
     */
    public function generateActivationCode($length = 8, $userName = '')
    {
        return substr(md5(time().'jashkdjh#*(UJLKF@H@)#$'. $userName), rand(1, 32-$length), $length);
    }

    /** Работа изображением (картинкой, аватаркой)  */




}
