<?php

require_once '../includes/visitor.inc.php';
include '../includes/admin-functions.inc.php';

global $LANGUAGES, $userAuth;

use Mnv\Core\Config;
use Mnv\Core\Filesystem\FilesystemManager;
use Mnv\Core\Locale\I18N;
use Mnv\Core\Uploads\Uploader;
use Mnv\Core\Uploads\UploaderPdf;
use Mnv\Modules\Jobs;

if (request()->ajax()) {
    $jobs = new Jobs();
    $error = false;

    $rewrite = request()->get('rewrite');
    $jobs->data = request()->get('brand');
    $jobs->description = request()->get('desc');

    if ($rewrite != Config::getValue('rewrite')) {
        header("HTTP/1.0 301 Moved Permanently");
        header("Location: ".SITE_URL);
        exit;
    }

    loadLanguage(Config::getValue('admin_language'));

    $filesystem = new FilesystemManager('/uploads', '/brands/');
    $upload = new Uploader('', $filesystem->realPath, $filesystem->path, 0);
    $pdf = new UploaderPdf('', $filesystem->realPath, $filesystem->path, 0);

    if ($upload->validate()) {
        $upload->upload();
    } else {
        $jobs->response = $upload->response;
        $error = true;
    }
    if ($pdf->error) {
        $jobs->response = $pdf->response;
        $error = true;
    }

    if (empty($jobs->data['nomination'])) {
        $jobs->response = array('status' => 403, 'type' => 'error', 'message' => I18N::locale("Вы не указали номинацию.", "Siz nominatsiyani bermadingiz.", "You didn't specify a nomination."));
        $error = true;
    }

    if (empty($userAuth->getUserId())) {
        $jobs->response = array('status' => 403, 'type' => 'error', 'message' => I18N::locale("Вам необходимо авторизоваться.", "Siz tizimga kirishingiz kerak.", "You need to log in."));
        $error = true;
    }

    if (!empty($jobs->data) && !$error) {
        $jobs->response = $jobs->prepare($userAuth->getUserId(), $jobs->data, $LANGUAGES, $upload->response['fileId'], $pdf->uploaded)
            ? array('status' => 200, 'type' => 'success', 'redirect' => SITE_URL.'/my-application/', 'message' => I18N::locale("Поздравляем! Вы успешно добавили, отобразится на сайте после модерации.", "Tabriklaymiz! Siz muvaffaqiyatli qo'shdingiz, moderatsiyadan keyin saytda ko'rsatiladi.", "Congratulations! You have successfully added it, it will be displayed on the site after moderation."))
            : array('status' => 403, 'type' => 'error', 'message' => I18N::locale("Ошибка при добавление, перезагрузите страницу и повторите.", "Xato qo'shish, sahifani qayta yuklang va takrorlang.", "Error when adding, reload the page and repeat."));
    }

    return response()->json($jobs->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();
} else {
    die('Access denied!');
}
