{include file="header.tpl" title="" keywords=$section.keywords description=$section.description}


<main class="main">
	
	{* ГЛАВНЫЙ ЭКРАН *}
	<section class="intro">

		<div class="intro__img">
			<img src="{$ASSETS_URL}/images/bg/1.jpg" alt="">
		</div>

		<div class="flex:col-max">

			<div class="intro__desc">

				<div class="text-tmp title-52 txt-20 txt-fw-600 color-white">
					{$section.content nofilter}
					<h1>{$section.name}</h1>
				</div>

			</div>

		</div>

		<div class="intro__footer" id="reglament">
			<div class="flex:col-max">

				<div class="intro__footer-content">

					<div class="intro__btns">
						{include file="blocks/block-button-participate.tpl" class="btn accent"}
						{include file="blocks/block-button-reglament.tpl" class="btn accent-4"}
					</div>

					<div class="intro__decor">
						<img src="{$section.image.original}" alt="{$config.website_name}">
					</div>

				</div>

			</div>
		</div>

	</section>
	{* ГЛАВНЫЙ ЭКРАН *}

	{* КАЛЕНДАРЬ ПРЕМИИ *}
	{fetch_section assign=stagesSection section=6 getContent=true}{if !empty($stagesSection) && $stagesSection.status eq 'V'}
	<section class="flex:col pad-tb-80" id="about-award">
		<div class="flex:col-max">

			<div class="grid:fr-1 g-gap-60">

				<div class="text-tmp title-48 all-center">
					<h2>{$stagesSection.name}</h2>
				</div>

				<div class="date">
					{bracket_regex from=$stagesSection.content strip_tags=false}
					{foreach item=item from=$regex name=regex}
					<div class="date-card" style="background-image: url({$ASSETS_URL}/images/cards/calendar/{$smarty.foreach.regex.iteration}.jpg);">
						<div class="date-card__desc">

							<div class="text-tmp txt-24 txt-fw-600 color-white">
								<p>{$item.code}</p>
							</div>

							<div class="text-tmp txt-32 color-white">
								<p>{$item.content nofilter}</p>
							</div>
							
						</div>
						
						{if $smarty.foreach.regex.iteration eq 3}
						<div class="date-card__img">
							<img src="{$ASSETS_URL}/images/common/1.png" alt="">
						</div>
						{/if}
					</div>
					{/foreach}

				</div>

			</div>

		</div>
	</section>
	{/if}
	{* КАЛЕНДАРЬ ПРЕМИИ *}
	
	{* ЗАЧЕМ УЧАСТВОВАТЬ *}
	{fetch_section assign=whyParticipateSection section=7 getContent=true}{if !empty($whyParticipateSection) && $whyParticipateSection.status eq 'V'}
	<section class="flex:col pad-tb-80" id="{$whyParticipateSection.fileName}">
		<div class="flex:col-max">

			<div class="grid:fr-1 g-gap-60">

				<div class="text-tmp title-48 all-center">
					<h2>{$whyParticipateSection.name}</h2>
				</div>
				
				{fetch_sections assign=infoSections from=$whyParticipateSection.sectionId status="V" getContent=true image=true}{if !empty($infoSections)}
				<div class="grid:fr-3 g-gap-20 cards">
					
					{foreach item=infoSection from=$infoSections name=infoSections}
					<div class="step-card">

						<div class="step-card__img">
							<img src="{$infoSection.image.original}" alt="{$infoSection.name}">
						</div>

						<div class="step-card__desc">
							<div class="text-tmp title-24 title-color-accent gap-all-10 ">
								<h3>{$infoSection.name}</h3>
								<p>{$infoSection.content nofilter}</p>
							</div>
						</div>

					</div>
					{/foreach}

				</div>

				{include file="blocks/block-button-participate.tpl" class="btn accent x-center"}

			</div>
			{/if}

		</div>
	</section>
	{/if}
	{* ЗАЧЕМ УЧАСТВОВАТЬ *}

	{* РАСЧЕТ СТОИМОСТИ БРЕНДА *}
	{fetch_section assign=costSection section=141 getContent=true}{if !empty($costSection) && $costSection.status eq 'V'}
	<section class="flex:col pad-tb-80 bg-white">
		<div class="flex:col-max">

			<div class="grid:fr-1 g-gap-60">

				<div class="text-tmp title-48 all-center">
					<h2>{$costSection.name}</h2>
				</div>

				<div class="text-block">

					<div class="text-block__item">
						<div class="text-tmp txt-20">
							{$costSection.content nofilter}
						</div>

						{include file="blocks/block-button-reglament.tpl" class="btn accent"}
					</div>

					<div class="text-block__item">
						<div class="text-tmp txt-20">
							<img src="{$costSection.image.original}" alt="{$costSection.name}">
						</div>
					</div>

				</div>

			</div>

		</div>
	</section>
	{/if}
	{* РАСЧЕТ СТОИМОСТИ БРЕНДА *}
	
	
	{* УЧАСТНИКИ ПРЕМИИ *}
	{fetch_section assign=participantsSection section=145 getContent=true}{if !empty($participantsSection) && $participantsSection.status eq 'V'}
	<section class="flex:col pad-tb-80" id="participants">
		<div class="flex:col-max">

			<div class="grid:fr-1 g-gap-60">

				<div class="text-tmp title-48 all-center">
					<h2>{$participantsSection.name}</h2>
				</div>

				{fetch_sections assign=nominations from=3 status="V" getContent=true}{if !empty($nominations)}
				<div class="grid:fr-1 g-gap-10">
					{foreach item=nomination from=$nominations name=nominations}
					{fetch_nominees_count assign=countJobs section=$nomination.sectionId}
					<a class="participants-card" href="{$SITE_URL}{$nomination.url}">

						<div class="participants-card__desc">
							<div class="text-tmp txt-24 txt-fw-500">
								<p>{$nomination.name}</p>
							</div>
						</div>

						<div class="participants-card__other">

							<div class="participants-card__country">
								<span class="participants-card__country-item" style="background-image: url({$ASSETS_URL}/images/cards/participants/1.png);"></span>
								<span class="participants-card__country-item" style="background-image: url({$ASSETS_URL}/images/cards/participants/2.png);"></span>
							</div>

							<div class="participants-card__number">
								<div class="text-tmp txt-24 txt-fw-500">
									<p>{$countJobs.count}</p>
								</div>
							</div>

						</div>

					</a>
					{/foreach}

				</div>
				{/if}

			</div>

		</div>
	</section>
	{/if}
	{* УЧАСТНИКИ ПРЕМИИ *}

	{* ЭКСПЕРТНОЕ ЖЮРИ *}
	{fetch_section assign=jurySection section=4 getContent=true}{if !empty($jurySection) && $jurySection.status eq 'V'}
	<section class="flex:col pad-tb-80 bg-white" id="{$jurySection.fileName}">
		<div class="flex:col-max">

			<div class="grid:fr-1 g-gap-60">

				<div class="text-tmp title-48 all-center">
					<h2>{$jurySection.name}</h2>
				</div>
				
				{fetch_articles limit=8 assign=judges image=true section=$jurySection.sectionId order="title ASC"}
				<div class="grid:fr-4 g-gap-20 cards">
					
					{foreach from=$judges item=judge}
					<a class="expert-card" href="{$SITE_URL}{$judge.url}">
						<div class="expert-card__img">
							<img src="{$judge.image.original}" alt="{$judge.title}">
						</div>

						<div class="expert-card__desc">
							<div class="text-tmp title-24 gap-all-10">
								<h3>{$judge.title}</h3>

								<p>{$judge.alias}</p>
							</div>
						</div>
					</a>
					{/foreach}

				</div>
				
				{* <a class="btn accent x-center" href="{$SITE_URL}{$jurySection.url}">
					Весь состав жюри
				</a> *}

			</div>

		</div>
	</section>
	{/if}
	{* ЭКСПЕРТНОЕ ЖЮРИ *}
	
	{* ОРГАНИЗАТОРЫ И ПАРТНЕРЫ *}
	{fetch_sections assign=partnersSections from=5 status="V" image=true imageType='gallery'}{if !empty($partnersSections)}
	<section class="flex:col pad-tb-80" id="partners">
		<div class="flex:col-max">

			<div class="grid:fr-1 g-gap-60">
				
				{foreach item=partnersSection from=$partnersSections name=partnersSections}
				{if !empty($partnersSection.gallery)}
				<div class="grid:fr-1 g-gap-60">

					<div class="text-tmp title-48 all-center">
						<h2>{$partnersSection.name}</h2>
					</div>

					<div class="block-cards">
						
						{foreach from=$partnersSection.gallery item=gallery}
							{if !empty($gallery.link)}
								<a href="{$gallery.link}" target="_blank" class="partners-card"><div class="partners-card__img"><img src="{$gallery.original}" alt="{$gallery.title}"></div></a>
							{else}
								<div class="partners-card">
									<div class="partners-card__img">
										<img src="{$gallery.original}" alt="{$gallery.title}">
									</div>
								</div>
							{/if}
						{/foreach}

					</div>

				</div>
				{/if}
				{/foreach}

			</div>

		</div>
	</section>
	{/if}
	{* ОРГАНИЗАТОРЫ И ПАРТНЕРЫ *}

</main>

{include file="footer.tpl"}