{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

{if isset($siteUser.userId)}
	<main class="main">

		<div class="flex:col">
			<div class="intro">
				<div class="intro__bg"><img src="{$ASSETS_URL}/images/bg/3.jpg" alt="{$section.name}"></div>
			</div>
		</div>

		<section class="flex:col pad-tb-100">
			<div class="flex:col-max">

				<div class="grid:fr-1 g-gap-60">

					<div class="text-tmp title-44 txt-18 title-tt-up marg-all-10">
						<h1>{$section.name}</h1>
						{$section.content nofilter}
					</div>

					{fetch_user_nominees limit=100 assign=nominees userId=$siteUser.userId}{if !empty($nominees)}
					<div class="table">
						<table>
							<thead>
							<tr>
								<td>Название бренда</td>
								<td>Дата подачи</td>
								<td>Статус заявки</td>
								<td>Статус оплаты</td>
								<td></td>
							</tr>
							</thead>

							<tbody class="nominees">
							{foreach from=$nominees item=nominee}
								{include file="items/item-nominee.tpl"}
							{/foreach}
							</tbody>
						</table>
					</div>
					{/if}

					<div class="btn-berwen">
						<a class="btn accent large" href="{$SITE_URL}/add-application/">Подать заявку <span>{include file="icon/svg.tpl" svgId="next_icon" fill="none"}</span></a>
						<div><div class="text-tmp txt-20"><p><a href="{$SITE_URL}/ajax-user-sign-out">Выйти</a></p></div></div>
					</div>

				</div>

			</div>
		</section>

	</main>

	<div class="d-none">
		<div class="modal" id="modalForm">
			<div class="modal__inner">

				<div class="text-tmp title-20">
					<h3>ДУБЛИРОВАНИЕ <span class="company-name_js"></span> В ДРУГУЮ НОМИНАЦИЮ</h3>
					<p class="notify"></p>
				</div>

				<form class="form validation_js" action="{$SITE_URL}/ajax-brand-copy" method="post" id="copy">

					<input class="name-conpany_js" name="brand" hidden type="text">
					<div class="input">
						<div class="select-custom select-custom_js">
							<select name="nomination" id>
								<option hidden value="0">Выберите номинацию</option>
								{fetch_sections assign=nominations from=3 status="V" getContent=true}{if !empty($nominations)}
								{foreach item=nomination from=$nominations name=nominations}
								<option value="{$nomination.sectionId}">{$nomination.name}</option>
								{/foreach}{/if}
							</select>
						</div>
					</div>

					<button class="btn accent small x-center" type="submit">Подтвердить</button>
				</form>

			</div>
		</div>
	</div>
{else}
	<script>
		window.location = "{$SITE_URL}";
	</script>
{/if}

{include file="footer.tpl"}